% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R
\name{substitute_values}
\alias{substitute_values}
\title{Substitute values of parameters in a SLiM extension template}
\usage{
substitute_values(template, ...)
}
\arguments{
\item{template}{Either a path to an extension script file, or a string
containing the entire SLiM extension code}

\item{...}{Named function arguments interpreted as key=value pairs to be
used in argument substitution}
}
\value{
Path to a file with a saved extension script containing all
substituted values
}
\description{
Substitute values of templated \{\{parameters\}\} in a given SLiM extension template
}
\details{
If a file or a multi-line string given as \code{template} contains parameters
specified as \{\{param\}\} where "param" can be arbitrary variable name, this
function substitutes each templated \{\{parameter\}\} for a given values. Such
modified template is then used to extend a built-in slendr SLiM script, allowing
for a customization of its default behavior (most commonly replacing its
assumption of neutrality for non-neutral scenarios, such as simulations of
natural selection).
}
