% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{getDuration}
\alias{getDuration}
\title{Get duration}
\usage{
getDuration(
  x,
  samplingRate = NULL,
  silence = 0.01,
  rms = list(windowLength = 20, step = 5),
  reportEvery = NULL,
  cores = 1
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{silence}{leading and trailing sections quieter than this proportion of
maximum RMS amplitude are removed when calculating
\code{duration_noSilence} (NULL = don't calculate \code{duration_noSilence}
to save time)}

\item{rms}{a list of control parameters passed to \code{\link{getRMS}}}

\item{reportEvery}{when processing multiple inputs, report estimated time
left every ... iterations (NULL = default, NA = don't report)}

\item{cores}{number of cores for parallel processing}
}
\value{
Returns \code{duration} (s) and \code{duration_noSilence} (duration
  without leading and trailing silences).
}
\description{
Returns the duration of one or more audio files (mostly useful for running on
an entire folder). If \code{threshold} is set, it also removes the leading
and trailing silences or near-silences, thus returning the duration of
relatively loud central fragments of each sound. Silences are located based
on the amplitude of root mean square (RMS) amplitude with
\code{\link{getRMS}}. Note that the threshold is set relative to the observed
maximum RMS, just as in \code{\link{analyze}}. This means that even very
quiet sounds are not treated as nothing but silence.
}
\examples{
s = c(rep(0, 550), runif(400, -1, 1), rep(0, 50))
osc(s, samplingRate = 1000)
# true duration_noSilence is 400 ms
getDuration(s, samplingRate = 1000, silence = .01)
getDuration(s, samplingRate = 1000, silence = .1,
            rms = list(windowLength = 5, step = 1))

\dontrun{
d = getDuration('~/Downloads/temp')
hist(d$duration - d$duration_noSilence)
}
}
\seealso{
\code{\link{analyze}} \code{\link{getLoudness}}
}
