% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ienkf.R
\name{ienkf}
\alias{ienkf}
\alias{ienkf-spatPomp}
\alias{ienkf,spatPomp-method}
\title{Iterated ensemble Kalman filter (IEnKF)}
\usage{
\S4method{ienkf}{spatPomp}(
  data,
  Nenkf = 1,
  rw.sd,
  cooling.type = c("geometric", "hyperbolic"),
  cooling.fraction.50,
  Np,
  ...,
  verbose = getOption("spatPomp_verbose", FALSE)
)
}
\arguments{
\item{data}{an object of class \code{spatPomp}}

\item{Nenkf}{number of iterations of perturbed EnKF.}

\item{rw.sd}{specification of the magnitude of the random-walk perturbations that will be applied to some or all model parameters.
Parameters that are to be estimated should have positive perturbations specified here.
The specification is given using the \code{\link[pomp]{rw_sd}} function, which creates a list of unevaluated expressions.
The latter are evaluated in a context where vector of observation times is visible (as \sQuote{\code{time}}).
The expression \code{ivp(s)} can be used in this context as shorthand for \preformatted{ifelse(time==time[1],s,0).}
Likewise, \code{ivp(s,lag)} is equivalent to \preformatted{ifelse(time==time[lag],s,0).}
See below for some examples.

The perturbations that are applied are normally distributed with the specified s.d.
If parameter transformations have been supplied, then the perturbations are applied on the transformed (estimation) scale.}

\item{cooling.type, cooling.fraction.50}{specifications for the cooling schedule,
i.e., the manner and rate with which the intensity of the parameter perturbations is reduced with successive filtering iterations.
\code{cooling.type} specifies the nature of the cooling schedule.
See below (under \dQuote{Specifying the perturbations}) for more detail.}

\item{Np}{The number of particles used within each replicate for the adapted simulations.}

\item{...}{Additional arguments can be used to replace model components.}

\item{verbose}{logical; if \code{TRUE}, messages updating the user on progress will be printed to the console.}
}
\value{
Upon successful completion, \code{ienkf} returns an object of class
\sQuote{ienkfd_spatPomp}. This object contains the convergence record of the iterative algorithm with
respect to the likelihood and the parameters of the model (which can be accessed using the \code{traces}
attribute) as well as a final parameter estimate, which can be accessed using the \code{coef()}.
}
\description{
An implementation of a parameter estimation algorithm that uses
the ensemble Kalman filter (Evensen, G. (1994)) to perform the filtering step in the
parameter-perturbed iterated filtering scheme of Ionides et al. (2015)
following the pseudocode in Asfaw, et al. (2020).
}
\section{Methods}{

The following methods are available for such an object:
\describe{
\item{\code{\link{coef}}}{ gives the Monte Carlo estimate of the maximum likelihood. }
}
}

\references{
\asfaw2020

Evensen, G. (1994) Sequential data assimilation with a
nonlinear quasi-geostrophic model using Monte Carlo methods to forecast
error statistics Journal of Geophysical Research: Oceans 99:10143--10162

Evensen, G. (2009) Data assimilation: the ensemble Kalman filter
Springer-Verlag.

Anderson, J. L. (2001) An Ensemble Adjustment Kalman Filter for Data
Assimilation Monthly Weather Review 129:2884--2903
}
\seealso{
likelihood evaluation algorithms: \code{girf()}, \code{enkf()}, \code{bpfilter()}, \code{abf()}, \code{abfir()}

Other likelihood maximization algorithms: 
\code{\link{ibpf}()},
\code{\link{igirf}()},
\code{\link{iubf}()}
}
\author{
Kidus Asfaw
}
\concept{likelihood maximization algorithms}
