% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendall.R
\name{kendall}
\alias{kendall}
\title{Kendall tau trend with continuity correction for time-series}
\usage{
kendall(
  y,
  tau = TRUE,
  intercept = TRUE,
  p.value = TRUE,
  confidence = TRUE,
  method = c("zhang", "yuepilon", "none"),
  threshold = 6,
  ...
)
}
\arguments{
\item{y}{A vector representing a timeseries with >= 8 obs}

\item{tau}{(FALSE/TRUE) return tau values}

\item{intercept}{(FALSE/TRUE) return intercept values}

\item{p.value}{(FALSE/TRUE) return p.values}

\item{confidence}{(FALSE/TRUE) return 95 pct confidence levels}

\item{method}{Method for deriving tau and slope ("zhang", "yuepilon", "none")}

\item{threshold}{The threshold for number of minimum observations in the time-series}

\item{...}{Not used}
}
\value{
Depending on arguments, a vector containing:
\itemize{
\item Theil-Sen slope, always returned
\item Kendall's tau two-sided test, if tau TRUE
\item intercept for trend if intercept TRUE
\item p value for trend fit if p.value TRUE
\item lower confidence level at 95-pct if confidence TRUE
\item upper confidence level at 95-pct if confidence TRUE
}
}
\description{
Calculates a nonparametric statistic for a monotonic trend based
on the Kendall tau statistic and the Theil-Sen slope modification
}
\details{
This function implements Kendall's nonparametric test for a monotonic trend
using the Theil-Sen (Theil 1950; Sen 1968; Siegel 1982) method to estimate
the slope and related confidence intervals. Critical values are Z > 1.96
representing a significant increasing trend and a Z < -1.96 a significant
decreasing trend (p < 0.05). The null hypothesis can be rejected if Tau = 0.
Autocorrelation in the time-series is addressed using a prewhitened linear trend
following the Zhang et al., (2000) or  Yue & Pilon (2002) methods. If you do not
have autocorrelation in the data, the "none" or "yuepilon" method is recommended.
Please note that changing the threshold to fewer than 6 observations (ideally 8) may
prevent the function from failing but, will likely invalidate the statistic.
A threshold of <=4 will yield all NA values. If method= "none" a modification of the
EnvStats::kendallTrendTest code is implemented.
}
\examples{
data(EuStockMarkets)
d <- as.vector(EuStockMarkets[,1])
kendall(d)

}
\references{
Theil, H. (1950) A rank invariant method for linear and polynomial regression
analysis. Nederl. Akad. Wetensch. Proc. Ser. A 53:386-392 (Part I),
53:521-525 (Part II), 53:1397-1412 (Part III).

Sen, P.K. (1968) Estimates of Regression Coefficient Based on Kendall's tau.
Journal of the American Statistical Association. 63(324):1379-1389.

Siegel, A.F. (1982) Robust Regression Using Repeated Medians.
Biometrika, 69(1):242-244

Yue, S., P. Pilon, B. Phinney and G. Cavadias, (2002) The influence of autocorrelation
on the ability to detect trend in hydrological series.
Hydrological Processes, 16: 1807-1829.

Zhang, X., Vincent, L.A., Hogg, W.D. and Niitsoo, A., (2000) Temperature
and Precipitation Trends in Canada during the 20th Century.
Atmosphere-Ocean 38(3): 395-429.
}
\seealso{
\code{\link[zyp]{zyp.trend.vector}} for model details
}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
