% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.kde.R
\name{sf.kde}
\alias{sf.kde}
\alias{sp.kde}
\title{Spatial kernel density estimate}
\usage{
sf.kde(
  x,
  y = NULL,
  bw = NULL,
  ref = NULL,
  res = NULL,
  standardize = FALSE,
  scale.factor = 10000,
  mask = FALSE
)
}
\arguments{
\item{x}{sf POINT object}

\item{y}{Optional values, associated with x coordinates, 
to be used as weights}

\item{bw}{Distance bandwidth of Gaussian Kernel, must be units 
of projection}

\item{ref}{A terra SpatRaster, vect, ext or sf vector, bbox 
vector to estimate the kde extent}

\item{res}{Resolution of raster when ref not SpatRaster}

\item{standardize}{Standardize results to 0-1 (FALSE/TRUE)}

\item{scale.factor}{Numeric scaling factor for the KDE (defaults to 10000),
to account for very small estimate values}

\item{mask}{(TRUE/FALSE) mask resulting raster if ref is provided
as a SpatRaster}
}
\value{
a terra SpatRaster class object containing kernel density estimate
}
\description{
A weighted or unweighted Gaussian Kernel Density estimate 
             for point spatial data
}
\details{
Please note that ks methods for estimation has been reverted to the Gussian method proposed
in Venables & Ripley (2002). There was not enought evendence that the Chacon & Duong (2018)
multivariate method(s) for bandwidth selection and kernal estimation were suitable for 
spatial random fields.
}
\examples{
\donttest{ 
library(sf) 
library(terra) 
  
data(meuse, package = "sp")
meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                  agr = "constant") 
  			
# Unweighted KDE (spatial locations only) with 40m resoultion  				
pt.kde <- sf.kde(x = meuse, bw = 1000, standardize = TRUE, res=40)
  plot(pt.kde, main="Unweighted kde")
    plot(st_geometry(meuse), pch=20, col="red", add=TRUE) 

# cadmium weighted KDE usign extent with 40m resoultion and 500m and 1000m bw 
cadmium.kde.500 <- sf.kde(x = meuse, y = meuse$cadmium, res=40, 
                          bw = 500, standardize = TRUE)
cadmium.kde.1000 <- sf.kde(x = meuse, y = meuse$cadmium, res=40, 
                          bw = 1000, standardize = TRUE)						  
  plot(c(cadmium.kde.500, cadmium.kde.1000))

# Using defined raster
r <- terra::rast(terra::ext(meuse), resolution =  40, 
		               crs=terra::crs(meuse))   
  pt.kde <- sf.kde(x = meuse, bw = 1000, standardize = TRUE,  ref = r) 
 
}

}
\references{
Duong, T. & Hazelton, M.L. (2005) Cross-validation bandwidth matrices for multivariate 
  kernel density estimation. Scandinavian Journal of Statistics, 32, 485-506. 

Wand, M.P. & Jones, M.C. (1994) Multivariate plug-in bandwidth selection. Computational 
  Statistics, 9, 97-116. 

Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. 
  Fourth edition. Springer.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
