/*
 * Decompiled with CFR 0.152.
 */
package partition;

import java.util.Arrays;
import partition.Cell;
import partition.Cluster;
import partition.CompactSpatialPartition;
import partition.Location;

public class CompactSpatialPartitionSwop
extends CompactSpatialPartition {
    public CompactSpatialPartitionSwop(Location[] cellCenters, int[] clusterId) {
        int numberOfCells = clusterId.length;
        int numberOfClusters = this.getNumberOfClusters(clusterId);
        this._clusters = new Cluster[numberOfClusters];
        for (int k = 0; k < numberOfClusters; ++k) {
            Cluster cluster;
            this._clusters[k] = cluster = new Cluster(k, cellCenters[0], false);
        }
        this._cells = new Cell[numberOfCells];
        for (int i = 0; i < numberOfCells; ++i) {
            Cell cell = new Cell(i, cellCenters[i]);
            Cluster cluster = this._clusters[clusterId[i]];
            cluster.add(cell);
            this._cells[i] = cell;
        }
    }

    private final int getNumberOfClusters(int[] clusterId) {
        int j = 0;
        int numberOfClusters = 1;
        int numberOfCells = clusterId.length;
        int[] tmp = Arrays.copyOf(clusterId, clusterId.length);
        Arrays.sort(tmp);
        int i = 1;
        while (i < numberOfCells) {
            if (tmp[j] != tmp[i]) {
                ++numberOfClusters;
            }
            j = i++;
        }
        return numberOfClusters;
    }

    @Override
    final int runCycle() {
        for (Cluster cluster : this._clusters) {
            cluster.deactivate();
        }
        int numberOfSwops = 0;
        block1: for (Cell cell1 : this._cells) {
            Cluster cluster1 = cell1.getCluster();
            boolean isActive1 = cluster1.isActive();
            Location cCell1 = cell1.getCenter();
            Location cCluster1 = cluster1.getCenter();
            double distance11 = cCell1.getSquaredDistanceTo(cCluster1);
            for (Cell cell2 : this._cells) {
                boolean swop;
                boolean isActive2;
                Cluster cluster2 = cell2.getCluster();
                if (cluster1 == cluster2 || !(isActive1 | (isActive2 = cluster2.isActive()))) continue;
                Location cCell2 = cell2.getCenter();
                Location cCluster2 = cluster2.getCenter();
                double distance12 = cCell1.getSquaredDistanceTo(cCluster2);
                double distance21 = cCell2.getSquaredDistanceTo(cCluster1);
                double distance22 = cCell2.getSquaredDistanceTo(cCluster2);
                boolean bl = swop = distance11 + distance22 > distance12 + distance21;
                if (!swop) continue;
                cluster1.remove(cell1);
                cluster2.remove(cell2);
                cluster1.add(cell2);
                cluster2.add(cell1);
                cluster1.activate();
                cluster2.activate();
                ++numberOfSwops;
                continue block1;
            }
        }
        return numberOfSwops;
    }
}

