% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell_functions.R
\name{spell_replace}
\alias{spell_replace}
\title{Probabilistic Spelling Correction}
\usage{
spell_replace(
  txt,
  word_list = coca_list,
  ignore_names = TRUE,
  threshold = 0.12,
  ignore_punct = FALSE
)
}
\arguments{
\item{txt}{A character vector containing text to be spell-checked}

\item{word_list}{A character vector of correctly spelled words sorted by
frequency (default: coca_list)}

\item{ignore_names}{Logical. If TRUE, ignores potential proper names
(capitalized words that appear multiple times)}

\item{threshold}{Numeric. Maximum string distance threshold for considering
a word as a correction candidate (default: 0.12)}

\item{ignore_punct}{Logical. If TRUE, ignores punctuation when calculating
string distance}
}
\value{
A character vector with corrected spellings
}
\description{
Automatically replaces misspelled words in a character vector based on their
string distance from a list of words sorted by frequency in a corpus.
}
