#' LIMIT statement.
#'
#' This class represents a SQL LIMIT statement. It requires a single
#' integer limit value.
#'
#' @examples
#' # Create a LIMIT statement with a limit of 10:
#' limit <- StmtLimit$new(10L)
#'
#' # Use the created LIMIT statement inside a SELECT query:
#' query <- QuerySelect$new(StmtSelectAll$new(),
#'                          from = StmtFrom$new("books"))
#' query$add(limit)
#'
#' @import R6
#' @include Statement.R
#' @export
StmtLimit <- R6::R6Class("StmtLimit",
  inherit = Statement,
  public = list(

    #' @description
    #' Initializer
    #' @param limit The integer limit.
    #' @return Nothing.
    initialize = function(limit) {
      chk::chk_whole_number(limit)
      chk::chk_true(limit >= 0L)
      private$limit <- limit
      super$initialize()
      return(invisible(NULL))
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      return(list(.limit, .spc, TokenValue$new(private$limit)))
    }
  ),
  private = list(
    limit = NULL
  )
)
