testthat::context("TokenIdentifier class")

testthat::test_that("Conversion to string works fine", {
  testthat::expect_error(TokenIdentifier$new(""))
  testthat::expect_equal(TokenIdentifier$new("a")$toString(), "a")
  testthat::expect_equal(TokenIdentifier$new("A")$toString(), "A")
  testthat::expect_equal(TokenIdentifier$new("a_b")$toString(), "a_b")
  testthat::expect_equal(TokenIdentifier$new("a b")$toString(), '"a b"')
  testthat::expect_equal(TokenIdentifier$new("a'b")$toString(), "\"a'b\"")
  testthat::expect_equal(TokenIdentifier$new('a"b')$toString(), '"a""b"')
  testthat::expect_equal(TokenIdentifier$new("a:b")$toString(), "\"a:b\"")

  # Keywords
  all_kwds <- c(tolower(sqlq:::.SQL_KEYWORDS), toupper(sqlq:::.SQL_KEYWORDS))
  set.seed(0L)
  for (kwd in sample(all_kwds, 10))
    testthat::expect_equal(TokenIdentifier$new(kwd)$toString(),
                          paste0('"', kwd, '"'))
})

testthat::test_that("The ALWAYS QUOTE option works fine", {
  options(sqlq_always_quote = TRUE)
  testthat::expect_equal(TokenIdentifier$new("A")$toString(), '"A"')
  options(sqlq_always_quote = FALSE)
})
