% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{boron_pred}
\alias{boron_pred}
\title{Model Averaged Predictions for CCME Boron Data}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 99 rows and 15 columns.
}
\usage{
boron_pred
}
\description{
A data frame of the predictions based on 1,000 bootstrap iterations.
}
\details{
\describe{
\item{proportion}{The proportion of species affected (int).}
\item{est}{The estimated concentration (dbl).}
\item{se}{The standard error of the estimate (dbl).}
\item{lcl}{The lower confidence limit (dbl).}
\item{se}{The upper confidence limit (dbl).}
\item{dist}{The distribution (chr).}
}
}
\examples{
\dontrun{
fits <- ssd_fit_dists(ssddata::ccme_boron)
withr::with_seed(50, {
  boron_pred <- predict(fits, ci = TRUE)
})
head(boron_pred)
}
}
\concept{boron}
\keyword{internal}
