% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{which_top_n}
\alias{which_top_n}
\title{Top or bottom \code{n} elements of a vector}
\usage{
which_top_n(x, n, tied = c("given", "all", "none"))
}
\arguments{
\item{x}{a vector on which \code{\link[=rank]{rank()}} can be evaluated.}

\item{n}{the number of elements to attempt to select; if positive
top \code{n} are selected, and if negative bottom \code{-n}.}

\item{tied}{a string to specify how to handle multiple elements
tied for \code{n}'th place: \code{all} or \code{none} to include all or none of
the tied elements, returning a longer or shorter vector than \code{n},
respectively; \code{given} (the default) to use the order in which the
elements are found in \code{x}.}
}
\value{
An integer vector of indices on \code{x}, with an attribute
\code{attr(, "tied")} with the indicies of the tied elements (possibly
empty).
}
\description{
Return the indices of the top or bottom \code{abs(n)} elements of a
vector, with several methods for resolving ties.
}
\examples{

(x <- rep(1:4, 1:4))

stopifnot(identical(which_top_n(x, 5, "all"), structure(4:10, tied = 4:6)))
stopifnot(identical(which_top_n(x, 5, "none"), structure(7:10, tied = 4:6)))
stopifnot(identical(which_top_n(x, 5), structure(6:10, tied = 4:6)))

stopifnot(identical(which_top_n(x, -5, "all"), structure(1:6, tied = 4:6)))
stopifnot(identical(which_top_n(x, -5, "none"), structure(1:3, tied = 4:6)))
stopifnot(identical(which_top_n(x, -5), structure(1:5, tied = 4:6)))

}
