% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.cor}
\alias{ci.cor}
\title{Confidence interval for a Pearson or partial correlation}
\usage{
ci.cor(alpha, cor, s, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor}{estimated Pearson or partial correlation}

\item{s}{number of control variables}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated correlation (from input)
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a Fisher confidence interval for a population Pearson correlation
or partial correlation with s control variables. Set s = 0 for a Pearson
correlation. A bias adjustment is used to reduce the bias of the Fisher
transformed correlation. This function uses an estimated correlation as
input. Use the cor.test function for raw data input.

For more details, see Section 1.14 of Bonett (2021, Volume 2)
}
\examples{
ci.cor(.05, .60, 0, 150)

# Should return:
# Estimate      SE    LL     UL
#      0.6 0.05243 0.485 0.6925

ci.cor(.05, .70, 1, 135)

# Should return:
# Estimate      SE     LL     UL
#      0.7 0.04406 0.6002 0.7763
 

}
\references{
\insertRef{Snedecor1980}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
