% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{ForestDataset}
\alias{ForestDataset}
\title{Dataset used to sample a forest}
\description{
A dataset consists of three matrices / vectors: covariates,
bases, and variance weights. Both the basis vector and variance
weights are optional.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data_ptr}}{External pointer to a C++ ForestDataset class}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ForestDataset-new}{\code{ForestDataset$new()}}
\item \href{#method-ForestDataset-update_basis}{\code{ForestDataset$update_basis()}}
\item \href{#method-ForestDataset-update_variance_weights}{\code{ForestDataset$update_variance_weights()}}
\item \href{#method-ForestDataset-num_observations}{\code{ForestDataset$num_observations()}}
\item \href{#method-ForestDataset-num_covariates}{\code{ForestDataset$num_covariates()}}
\item \href{#method-ForestDataset-num_basis}{\code{ForestDataset$num_basis()}}
\item \href{#method-ForestDataset-get_covariates}{\code{ForestDataset$get_covariates()}}
\item \href{#method-ForestDataset-get_basis}{\code{ForestDataset$get_basis()}}
\item \href{#method-ForestDataset-get_variance_weights}{\code{ForestDataset$get_variance_weights()}}
\item \href{#method-ForestDataset-has_basis}{\code{ForestDataset$has_basis()}}
\item \href{#method-ForestDataset-has_variance_weights}{\code{ForestDataset$has_variance_weights()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-new"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-new}{}}}
\subsection{Method \code{new()}}{
Create a new ForestDataset object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$new(covariates, basis = NULL, variance_weights = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{covariates}}{Matrix of covariates}

\item{\code{basis}}{(Optional) Matrix of bases used to define a leaf regression}

\item{\code{variance_weights}}{(Optional) Vector of observation-specific variance weights}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ForestDataset} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-update_basis"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-update_basis}{}}}
\subsection{Method \code{update_basis()}}{
Update basis matrix in a dataset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$update_basis(basis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{basis}}{Updated matrix of bases used to define a leaf regression}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-update_variance_weights"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-update_variance_weights}{}}}
\subsection{Method \code{update_variance_weights()}}{
Update variance_weights in a dataset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$update_variance_weights(variance_weights, exponentiate = F)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variance_weights}}{Updated vector of variance weights used to define individual variance / case weights}

\item{\code{exponentiate}}{Whether or not input vector should be exponentiated before being written to the Dataset's variance weights. Default: F.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-num_observations"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-num_observations}{}}}
\subsection{Method \code{num_observations()}}{
Return number of observations in a \code{ForestDataset} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$num_observations()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Observation count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-num_covariates"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-num_covariates}{}}}
\subsection{Method \code{num_covariates()}}{
Return number of covariates in a \code{ForestDataset} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$num_covariates()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Covariate count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-num_basis"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-num_basis}{}}}
\subsection{Method \code{num_basis()}}{
Return number of bases in a \code{ForestDataset} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$num_basis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Basis count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-get_covariates"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-get_covariates}{}}}
\subsection{Method \code{get_covariates()}}{
Return covariates as an R matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$get_covariates()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Covariate data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-get_basis"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-get_basis}{}}}
\subsection{Method \code{get_basis()}}{
Return bases as an R matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$get_basis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Basis data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-get_variance_weights"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-get_variance_weights}{}}}
\subsection{Method \code{get_variance_weights()}}{
Return variance weights as an R vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$get_variance_weights()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Variance weight data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-has_basis"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-has_basis}{}}}
\subsection{Method \code{has_basis()}}{
Whether or not a dataset has a basis matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$has_basis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
True if basis matrix is loaded, false otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ForestDataset-has_variance_weights"></a>}}
\if{latex}{\out{\hypertarget{method-ForestDataset-has_variance_weights}{}}}
\subsection{Method \code{has_variance_weights()}}{
Whether or not a dataset has variance weights
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ForestDataset$has_variance_weights()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
True if variance weights are loaded, false otherwise
}
}
}
