% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hfdr_plot.R
\name{PlotHypTree}
\alias{PlotHypTree}
\title{Interactively VIsualize a HypothesisTree}
\usage{
PlotHypTree(
  hyp.tree,
  adjust = TRUE,
  return_script = FALSE,
  width = 900,
  height = 500,
  base_font_size = 12,
  output_file_name = NULL
)
}
\arguments{
\item{hyp.tree}{An object of class \code{HypothesisTree}.}

\item{adjust}{Logical; if \code{TRUE}, use adjusted p-values for coloring.
If \code{FALSE}, use raw p-values.}

\item{return_script}{Logical; if \code{TRUE}, return the HTML/JS script as a
character string instead of writing to a file and opening in a browser.}

\item{width}{Width of the plot in pixels. Default is 900.}

\item{height}{Height of the plot in pixels. Default is 500.}

\item{base_font_size}{Base font size for node labels. Default is 12.}

\item{output_file_name}{Optional file name for the HTML output. If
\code{NULL}, a name is generated automatically.}
}
\value{
If \code{return_script} is \code{TRUE}, returns a character string
  containing the HTML/JS code. Otherwise, writes the visualization to an HTML
  file and opens it in the default browser (if interactive).
}
\description{
Generates a D3.js-based visualization of a \code{HypothesisTree}
object. Nodes are colored by p-value, and hovering over a node displays its
name and either the raw or adjusted p-value, depending on the \code{adjust}
argument.
}
\details{
The visualization displays the hierarchical structure of hypotheses. Node
color reflects the p-value, and hovering over a node shows its name and
p-value.
}
