% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number.R
\name{number}
\alias{number}
\alias{is_number}
\alias{as_number}
\title{\code{number} vector}
\usage{
number(x = numeric(), digits = 3L, scientific = FALSE, leading_zero = TRUE)

is_number(x)

as_number(x)
}
\arguments{
\item{x}{\itemize{
\item For \code{number()}: A numeric vector
\itemize{
\item For \code{is_number()}: An object to test
\item For \code{as_number()}: An object to coerce to a \code{number}
}
}}

\item{digits}{The number of digits to display after the decimal point.}

\item{scientific}{Whether the number should be represented with scientific notation (e.g. 1e2)}

\item{leading_zero}{Whether a leading zero should be used on numbers less than 0 (e.g. .001)}
}
\value{
An S3 vector of class \code{supernova_number}. It should behave like a double, but be
formatted consistently.
}
\description{
This creates a formatted double vector. You can specify the number of digits you want the value
to display after the decimal, and the underlying value will not change. Additionally you can
explicitly set whether scientific notation should be used and if numbers less than 0 should
contain a leading 0.
}
\examples{
number(1:5, digits = 3)
}
