#' @title Plot method for survAUC and survErr Objects
#' 
#' @description Plot method for survAUC and survErr Objects
#' 
#' @details Plot a \code{survAUC} object generated by the functions
#' \code{\link{AUC.uno}}, \code{\link{AUC.sh}}, \code{\link{AUC.cd}},
#' \code{\link{AUC.hc}} and \code{\link{predErr}}.
#' 
#' @name plot_survAUC_survErr
#' @rdname plot_survAUC_survErr
#' @param x An object of class \code{survAUC}.
#' @param col The color used to draw the AUC curve.
#' @param type The type of plot to be drawn. See argument 'type' of the
#' \code{\link{plot}} function.
#' @param ylim The y limits of the plot.
#' @param xlab The title of the x axis. See \code{\link{title}}.
#' @param ylab The title of the y axis. See \code{\link{title}}.
#' @param main The main title of the plot. See \code{\link{title}}.
#' @param add A logical specifying whether the AUC-Curve should be added to an
#' already existing plot.
#' @param \dots Graphics parameters that can be passed to 'plot'.
#' @seealso \code{\link{AUC.sh}}, \code{\link{AUC.cd}}, \code{\link{AUC.hc}},
#' \code{\link{AUC.uno}}, \code{\link{predErr}}
#' @keywords hplot classif
#' @examples
#' 
#' data(cancer,package="survival")
#' TR <- ovarian[1:16,]
#' TE <- ovarian[17:26,]
#' train.fit  <- survival::coxph(survival::Surv(futime, fustat) ~ age,
#'                     x=TRUE, y=TRUE, method="breslow", data=TR)
#' 
#' lp <- predict(train.fit)
#' lpnew <- predict(train.fit, newdata=TE)
#' Surv.rsp <- survival::Surv(TR$futime, TR$fustat)
#' Surv.rsp.new <- survival::Surv(TE$futime, TE$fustat)
#' times <- seq(10, 600, 10)                  
#' 
#' AUC_sh <- AUC.sh(Surv.rsp, Surv.rsp.new, lp, lpnew, times)
#' plot(AUC_sh)
#' abline(h = 0.5)
#' 
#' BrierScore <- predErr(Surv.rsp, Surv.rsp.new, lp, lpnew, times, 
#'                       type = "brier", int.type = "weighted")
#' plot(BrierScore)
#' abline(h = 0.25)
#' 
#' 
#' 
NULL

#' @rdname plot_survAUC_survErr
#' @aliases plot.survAUC
#' @exportS3Method base::plot
plot.survAUC <- function(x, col="red", type="l", ylim=c(0,1),
					xlab="Time",ylab="AUC", main="Time-dependent AUC", add=FALSE, ...)
{
	if(!add){
		plot(x$times, x$auc, ylim=ylim, main=main, xlab=xlab, ylab=ylab, col=col, type=type, ...)
	}
	else{
	  graphics::lines(x$times, x$auc, col=col, ...)
	}
}

#' @rdname plot_survAUC_survErr
#' @aliases plot.survErr
#' @exportS3Method base::plot
plot.survErr <- function(x, col="red", type="l", ylim=c(0,1),
xlab="Time",ylab="Prediction error", main="Time-dependent Prediction Error", add=FALSE, ...)
{
	if(!add){
		plot(x$times, x$error, ylim=ylim, main=main, xlab=xlab, ylab=ylab, col=col, type=type, ...)
	}
	else{
	  graphics::lines(x$times, x$error, col=col, ...)
	}
}

