\name{swGlmSiz}
\alias{swGlmSiz}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Sample Size of Stepped Wedge Cluster Randomized Trial (SW CRT) using GLMM
}
\description{
\code{swGlmSiz} is a wrapper function for \code{swGlmPwr}. For a given design, number of clusters, power and fixed and random effect parameters, \code{swGlmSiz} computes the number of individuals per cluster needed to achieve the desired power.
}
\usage{
swGlmSiz(power, alpha=0.05, ...)
%
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{power}{
numeric (scalar) Desired power. Must be between \eqn{\alpha} (default = 0.05) and 1.
}
  \item{alpha}{
numeric (scalar): Two-sided statistical significance level.
}
  \item{...}{
Arguments to be passed to \code{swGlmPwr}. See documentation for \code{swGlmPwr}.
}
}

\details{
\code{swGlmSiz} calls \code{swGlmPwr} iteratively to find the number of participants per cluster-period needed to achieve \code{power} power. Note that all warnings and messages normally generated by \code{swGlmPwr} are turned off. Also, the argument \code{retDATA} is set to \code{FALSE}. It is recommended that after using \code{swGlmSiz}, the user call \code{swGlmPwr} with the recommended sample size to view any warning messages and/or to get the data normally returned when \code{retDATA} is \code{TRUE}. 

An error in \code{swGlmPwr} causes \code{swGlmSiz} to terminate and the error message from \code{swGlmPwr} is printed. 
}

\value{

numeric (list): \code{swGlmSiz} returns a list of the following:
%% *****SPECIFY WHAT THESE ARE!!!!!**********
	\item{n}{
		scalar: number of individuals per cluster-period required to achieve the desired power.
	}
	\item{power}{
		scalar: exact power, as computed by \code{swGlmPwr}, obtained with the sample size \code{n}.
	}
}
\author{
Avi Kenny, James P Hughes
}
%\note{
%%  ~~further notes~~
%}
%
%% ~Make other sections like Warning with \section{Warning }{....} ~
%
%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
swGlmSiz(power = 0.8, design = swDsn(clusters=c(4,4,4,4)),distn = "binomial",
         fixed.intercept = log(0.1/0.9), fixed.treatment.effect = log(0.9), 
         fixed.time.effect=0, tau = 0.2)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ power }
\keyword{ stepped wedge }% __ONLY ONE__ keyword per line
\keyword{ cluster randomized trial }
