% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{to_tabr}
\alias{to_tabr}
\alias{from_chorrrds}
\alias{from_music21}
\title{Music notation syntax converters}
\usage{
to_tabr(id, ...)

from_chorrrds(x, key = "c", guitar = FALSE, gc_args = list())

from_music21(x, accidentals = c("flat", "sharp"), output = c("music", "list"))
}
\arguments{
\item{id}{character, suffix of \verb{from_*} function, e.g., \code{"chorrrds"}}

\item{...}{arguments passed to the function matched by \code{id}.}

\item{x}{character, general syntax input. See details and examples for how
inputs are structured for each converter.}

\item{key}{key signature, used to enforce consistent use of flats or sharps.}

\item{guitar}{logical, attempt to match input chords to known guitar chords
in \code{\link[=guitarChords]{guitarChords()}}. Otherwise by default standard piano chords of
consecutive pitches covering minimum pitch range are returned.}

\item{gc_args}{named list of additional arguments passed to \code{\link[=gc_info]{gc_info()}}, used
when \code{guitar = TRUE}.}

\item{accidentals}{character, represent accidentals, \code{"flat"} or \code{"sharp"}.}

\item{output}{character, type of output when multiple options are available.}
}
\value{
noteworthy string for chorrrds; music string or list for music21.
}
\description{
Convert alternative representations of music notation to \code{tabr} syntax.
}
\details{
These functions convert music notation from other data sources into the style
used by \code{tabr} for music analysis and sheet music transcription.
}
\section{Syntax converter for chorrrds}{

The input \code{x} is a character vector of chords output from the \code{chorrrds}
package, as shown in the examples. Output is a noteworthy string object.

Some sources do not offer as complete or explicit information in order to
make sheet music. However, what is available in those formats is converted
to the extent possible and available function arguments can allow the user
to add some additional specification. Different input syntax makes use of a
different syntax converter. Depending on the format, different arguments
may be available and/or required. The general wrapper function for all of
the available syntax converters is \code{to_tabr()}. This function takes an
\code{id} argument for the appropriate converter function. See examples.

For example, output from the \code{chorrrds} package that scrapes chord
information from the Cifraclub website only provides chords, not note for
note transcription data for any particular instrument. This means the result
of syntax conversion still yields only chords, which is fine for data
analysis but doesn't add anything useful for sheet music transcription.

The input in this case also does not specify distinct pitches by assigning
octaves numbers to a chord's notes, not even the root note. It remains up to
the user if they want to apply the information. By default, every chord
starts in octave three. It is also ambiguous how the chord is played since
all that is provided is a generic chord symbol. By default a standard chord
is constructed if it can be determined.

Setting \code{guitar = TRUE} switches to using the \code{\link[=guitarChords]{guitarChords()}} dataset to
find matching guitar chords using \code{\link[=gc_info]{gc_info()}}, which can be provided
additional arguments in a named list to \code{gc_args}. For guitar, this allows
some additional control over the actual structure of the chord, its shape and
position on the guitar neck. The options will never work perfectly for all
chords in \code{chords}, but at a minimum, typical default component pitches
will be determined and returned in \code{tabr} notation style.
}

\section{Syntax converter for music21}{

The input \code{x} is a character vector of in music21 tiny notation syntax,
as shown in the examples. Default output is a music object. Setting
\code{output = "list"} returns a list of three elements: a noteworthy string,
a note info string, and the time signature.

The recommendation for music21 syntax is to keep it simple. Do not use the
letter \code{n} for explicit natural notes. Do not add text annotations such
as lyrics. Double flats and sharps are not supported. The examples
demonstrate what is currently supported.
}

\examples{
# chorrrds package output
chords <- c("Bb", "Bbm", "Bbm7", "Bbm7(b5)", "Bb7(#5)/G", "Bb7(#5)/Ab")
from_chorrrds(chords)
to_tabr(id = "chorrrds", x = chords)

from_chorrrds(chords, guitar = TRUE)
to_tabr(id = "chorrrds", x = chords, guitar = TRUE)

# music21 tiny notation
x <- "4/4 CC#FF4.. trip{c#8eg# d'- e-' f g a'} D4~# D E F r B16"
from_music21(x)

from_music21(x, accidentals = "sharp")

from_music21(x, output = "list")
}
