% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{pkmod}
\alias{pkmod}
\title{Create a pkmod object}
\usage{
pkmod(
  pars_pk = NULL,
  init = NULL,
  pkfn = NULL,
  pars_pd = NULL,
  pdfn = NULL,
  pdinv = NULL,
  pcmpt = NULL,
  ecmpt = NULL,
  sigma_add = 0,
  sigma_mult = 0,
  log_response = FALSE,
  Omega = NULL
)
}
\arguments{
\item{pars_pk}{Vector or matrix of named PK parameters. If not specified, the pkmod function will be
inferred from the parameter names. Print `list_parnms()` for acceptable parameter names.}

\item{init}{Vector of initial concentrations. Will default to values of zero in all compartments if not specified.}

\item{pkfn}{PK model function. Functions provided in `tci` include `pkmod1cpt`, `pkmod2cpt`, `pkmod3cpt`, and `pkmod3cptm`.
User-defined functions should be specified here.}

\item{pars_pd}{PD model parameters if a PD model is specified}

\item{pdfn}{PD model function}

\item{pdinv}{Inverse PD model function for use in TCI algorithms}

\item{pcmpt}{Index of plasma compartment. Defaults to first compartment if not specified.}

\item{ecmpt}{Index of effect-site compartment if a PD model is specified. Will default to last compartment if unspecified.}

\item{sigma_add}{Standard deviation of additive residual error}

\item{sigma_mult}{Standard deviation of multiplicative residual error}

\item{log_response}{Logical value indicating if the response should be logged prior to adding error.}

\item{Omega}{Optional matrix of random effect parameters. Column names should correspond to names of
pars_pk, pars_pd, and sigma_add or sigma_mult.}
}
\value{
Returns a list with class "pkmod" if validation checks are passed. Returns an error if not.
}
\description{
User function to create pkmod objects with validation checks. Multiple rows are permitted for
arguments `pars_pk`, `pars_pd`, `init`
}
\examples{
# 1-compartment model
pkmod(pars_pk = c(CL = 10, V1 = 10))
# 2-compartment model
pkmod(pars_pk = c(CL = 10, V1 = 10, Q = 3, v2 = 20))
# 2-compartment model with random effects matrix
Omega <- matrix(diag(c(0.3,0.2,0,0.4)), 4,4, dimnames = list(NULL,c("CL","V1","Q","v2")))
pkmod(pars_pk = c(CL = 10, V1 = 10, Q = 3, v2 = 20), Omega = Omega)
}
