testthat::test_that("simple_reporter_srv - render and downlaod  a document", {
  shiny::testServer(
    simple_reporter_srv,
    args = list(reporter = test_reporter(), card_fun = test_card1),
    expr = {
      session$setInputs(`download_button_simple` = 0)
      session$setInputs(`download_button_simple-output` = "html_document")
      session$setInputs(`download_button_simple-title` = "TITLE")
      session$setInputs(`download_button_simple-author` = "AUTHOR")
      session$setInputs(`download_button_simple-download_data` = 0)

      f <- output[["download_button_simple-download_data"]]
      testthat::expect_true(file.exists(f))
      tmp_dir <- tempdir()
      output_dir <- file.path(tmp_dir, sprintf("report_test_%s", gsub("[.]", "", format(Sys.time(), "%Y%m%d%H%M%OS4"))))
      dir.create(path = output_dir)
      zip::unzip(f, exdir = output_dir)
      files <- list.files(output_dir, recursive = TRUE)
      testthat::expect_true(any(grepl("[.]Rmd", files)))
      testthat::expect_true(any(grepl("[.]html", files)))
    }
  )
})

testthat::test_that("simple_reporter_srv - add a Card (ReportCard) to Reporter", {
  testthat::skip_if_not_installed("ggplot2")
  card_fun0 <- function(card = rlang::with_options(lifecycle_verbosity = "quiet", ReportCard$new())) {
    card$append_text("Header 2 text", "header2")
    card$append_text("A paragraph of default text", "header2")
    card$append_plot(ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) +
      ggplot2::geom_histogram(binwidth = 0.2))
    card
  }

  shiny::testServer(
    simple_reporter_srv,
    args = list(reporter = Reporter$new(), card_fun = card_fun0),
    expr = {
      session$setInputs(`add_report_card_simple-add_report_card_button` = 0)
      session$setInputs(`add_report_card_simple-comment` = "Comment Body")
      session$setInputs(`add_report_card_simple-add_card_ok` = 0)
      # get_blocks() adds title, comment and comment body
      testthat::expect_identical(length(reporter$get_blocks()), length(card_fun()) + 3L)
    }
  )
})

testthat::test_that("simple_reporter_srv - add a Card (teal_card) to Reporter", {
  shiny::testServer(
    simple_reporter_srv,
    args = list(reporter = Reporter$new(), card_fun = test_card1),
    expr = {
      session$setInputs(`add_report_card_simple-add_report_card_button` = 0)
      session$setInputs(`add_report_card_simple-comment` = "Comment Body")
      session$setInputs(`add_report_card_simple-add_card_ok` = 0)
      # get_blocks() adds title, comment and comment body
      testthat::expect_identical(length(reporter$get_blocks()), length(card_fun()) + 3L)
    }
  )
})
