% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_init_data.R
\name{module_init_data}
\alias{module_init_data}
\alias{ui_init_data}
\alias{srv_init_data}
\title{Data Module for teal}
\usage{
ui_init_data(id)

srv_init_data(id, data)
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{data}{(\code{teal_data}, \code{teal_data_module}, or \code{reactive} returning \code{teal_data})
The data which application will depend on.}
}
\value{
A \code{reactive} object that returns:
Output of the \code{data}. If \code{data} fails then returned error is handled (after \code{\link[=tryCatch]{tryCatch()}}) so that
rest of the application can respond to this respectively.
}
\description{
This module manages the \code{data} argument for \code{srv_teal}. The \code{teal} framework uses \code{\link[teal.data:teal_data]{teal.data::teal_data()}},
which can be provided in various ways:
\enumerate{
\item Directly as a \code{\link[teal.data:teal_data]{teal.data::teal_data()}} object. This will automatically convert it into a \code{reactive} \code{teal_data}.
\item As a \code{reactive} object that returns a \code{\link[teal.data:teal_data]{teal.data::teal_data()}} object.
}
}
\details{
\subsection{Reactive \code{teal_data}:}{

The data in the application can be reactively updated, prompting \code{\link[=srv_teal]{srv_teal()}} to rebuild the
content accordingly. There are two methods for creating interactive \code{teal_data}:
\enumerate{
\item Using a \code{reactive} object provided from outside the \code{teal} application. In this scenario,
reactivity is controlled by an external module, and \code{srv_teal} responds to changes.
\item Using \code{\link[=teal_data_module]{teal_data_module()}}, which is embedded within the \code{teal} application, allowing data to
be resubmitted by the user as needed.
}

Since the server of \code{\link[=teal_data_module]{teal_data_module()}} must return a \code{reactive} \code{teal_data} object, both
methods (1 and 2) produce the same reactive behavior within a \code{teal} application. The distinction
lies in data control: the first method involves external control, while the second method
involves control from a custom module within the app.
}
}
\keyword{internal}
