% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{geom_azimuth}
\alias{geom_azimuth}
\title{Azimuth visualization}
\usage{
geom_azimuth(
  mapping = NULL,
  data = NULL,
  stat = "azimuth",
  center = TRUE,
  radius = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}.}

\item{data}{A data frame. If \code{NULL}, the default, the data is inherited from
the plot data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.}

\item{stat}{The statistical transformation to use on the data. Defaults to
\code{"identity"}.}

\item{center}{Logical; if \code{TRUE} (the default) spokes are centered on (x, y) using
\code{\link{PositionCenterSpoke}}  - useful for axial data. If \code{FALSE}, behaves like
\code{\link[ggplot2:geom_spoke]{ggplot2::geom_spoke()}} (line starts at (x, y)) - useful for directional data
(especially when in combination with \code{arrow()}).}

\item{radius}{Length of spoke}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a
warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than
combining with them.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{ggplot2::layer()}}. These are often
aesthetics (e.g. \code{colour}, \code{linetype}, \code{linewidth}, \code{alpha}).}
}
\value{
A ggplot2 layer that adds axis-like spokes.
}
\description{
\code{geom_azimuth()} visualizes axial-directional vector fields using a geom to
produce a new graphical layer, which allows aesthetic options.
This layer can be overlaid on a map to improve visualisation of mapped data.
The geom draws line segments (spokes) centered at (x, y) with a given
orientation (\code{angle} in degrees) and length (\code{radius}). By default the spoke
is centered using \code{\link{PositionCenterSpoke}}, so that the given coordinates mark
the middle of the line. The azimuths are given as angles in degrees increasing clockwise from North.
}
\section{Aesthetics}{

\code{geom_azimuth()} understands the following aesthetics (required aesthetics in \strong{bold}):
\itemize{
\item \strong{x}
\item \strong{y}
\item angle (in degrees, transformed internally)
\item radius
\item colour
\item alpha
\item linewidth
\item linetype
}
}

\examples{
set.seed(20250411)
df <- data.frame(
  x = runif(5), y = runif(5),
  angle_deg = rvm(5, mean = 90, kappa = 10),
  radius = runif(5, 0.1, 2)
)

if (require("ggplot2")) {
  ggplot(df, aes(x, y)) +
    geom_azimuth(aes(angle = angle_deg), radius = .1, linewidth = 1.2, colour = "blue")
  if (require("grid")) {
    ggplot(df, aes(x, y, radius = radius)) +
      geom_azimuth(aes(angle = angle_deg), center = FALSE, colour = "red", arrow = grid::arrow())
  }
}
}
\seealso{
\code{\link[ggplot2:geom_spoke]{ggplot2::geom_spoke()}}, \code{\link[=geom_azimuthpoint]{geom_azimuthpoint()}}
}
