# Test Fixtures
# ==============
# Test data used across multiple test files.

# Additional Test Data
# --------------------
# The swisspharma dataset in the package doesn't include monthly imports,
# but we need it for quarter-to-month disaggregation tests.

# Monthly imports (full series 1972-2011)
imports.m <- ts(
  c(
    256.023, 250.435, 283.282, 253.186, 270.172, 277.821, 248.297, 266.026,
    243.617, 287.12, 287.573, 252.667, 290.867, 266.997, 301.148, 255.017,
    313.349, 293.94, 297.728, 298.575, 279.209, 354.624, 327.204, 288.303,
    381.248, 399.54, 421.689, 442.056, 454.929, 417.335, 471.753, 412.143,
    410.699, 449.952, 390.984, 360.325, 377.846, 348.565, 328.617, 362.339,
    326.704, 320.706, 307.474, 263.728, 300.691, 312.609, 273.079, 310.238,
    322.766, 302.769, 366.396, 345.068, 349.797, 371.673, 363.255, 318.451,
    354.661, 377.687, 366.412, 380.27, 348.344, 361.915, 469.46, 385.619,
    402.251, 425.568, 381.722, 373.83, 387.026, 372.677, 373.833, 367.666,
    353.299, 325.657, 398.132, 363.648, 371.463, 395.33, 347.052, 327.108,
    336.313, 365.349, 374.156, 364.969, 372.517, 390.605, 455.901, 410.363,
    474.881, 447.255, 492.271, 429.349, 396.557, 491.75, 473.974, 447.611,
    508.308, 543.345, 613.658, 555.211, 518.097, 557.8, 528.644, 441.998,
    505.111, 541.337, 489.131, 479.235, 477.164, 548.372, 600.288, 544.257,
    536.997, 573.378, 558.802, 483.732, 584.199, 554.091, 532.345, 514.071,
    498.858, 532.813, 605.468, 540.336, 502.456, 589.41, 552.583, 490.637,
    557.648, 546.874, 611.827, 573.287, 520.855, 552.276, 628.397, 562.82,
    595.237, 620.29, 532.652, 524.202, 605.422, 614.217, 634.796, 583.545,
    624.459, 644.974, 684.1, 614.017, 706.173, 645.976, 673.155, 617.532,
    618.901, 742.922, 706.572, 603.476, 702.3, 728.957, 773.479, 802.739,
    764.926, 749.956, 789.231, 625.927, 707.533, 822.065, 732.364, 705,
    770.808, 708.803, 709.606, 816.367, 688.227, 748.127, 729.573, 583.688,
    690.34, 724.185, 632.529, 627.196, 633.493, 665.91, 759.194, 677.527,
    648.057, 711.384, 696.895, 660.894, 716.334, 744.142, 713.546, 707.224,
    649.853684, 738.637718, 854.374321, 742.07786, 761.530108, 803.471103, 765.663723, 743.201562,
    807.477359, 849.101196, 839.749567, 819.775699, 823.139315, 863.82257, 910.312369, 948.320254,
    943.767869, 965.381616, 882.81773, 806.538436, 870.403378, 930.843009, 941.18064, 833.399978,
    900.569345, 892.943121, 982.207198, 869.852232, 922.132386, 897.017945, 889.450238, 814.838304,
    823.463517, 947.234, 934.859834, 749.896447, 909.995603, 877.653646, 924.554234, 953.102123,
    874.657639, 864.712768, 936.815183, 781.811067, 844.285373, 951.11336, 953.08811, 801.422203,
    969.432144, 962.717624, 1032.160663, 979.796666, 878.746375, 1084.536279, 1004.242024, 797.424572,
    942.203021, 1014.342963, 943.087751, 844.730289, 877.197396, 935.850345, 990.613421, 1045.355598,
    911.7985, 1071.036944, 983.542035, 931.788749, 1005.149728, 1023.570638, 1083.974225, 994.27343,
    925.542958, 961.324318, 1141.559016, 1015.794971, 995.946353, 1108.704016, 991.170136, 965.911537,
    1110.315576, 1088.439279, 1151.425697, 1084.536111, 892.942987, 1011.386831, 1191.088837, 1055.233206,
    1164.778306, 1220.699017, 954.017385, 1065.074432, 1050.282558, 1211.497701, 1230.772374, 934.491792,
    1117.940832, 1105.884067, 1164.464032, 1137.771115, 1142.983939, 1143.479679, 1222.787546, 941.710043,
    1069.056518, 1287.574545, 1172.485816, 1014.136144, 1283.194662, 1215.865745, 1308.954449, 1665.189493,
    1299.42468, 1377.733495, 1561.024088, 1290.438757, 1404.380276, 1694.058835, 1343.910077, 1349.139789,
    1378.29203, 1429.066782, 1513.12955, 1534.765256, 1426.596905, 1689.627969, 1605.763597, 1302.264149,
    1479.736706, 1536.9538, 1545.685597, 1354.795672, 1246.379968, 1384.626963, 1727.330378, 1519.574174,
    1494.004253, 1688.20325, 1617.579509, 1557.713608, 1742.781819, 1655.823172, 1798.522506, 1889.559974,
    1569.419301, 1624.43456, 1859.809472, 1691.837966, 1840.880653, 1841.39625, 1958.426633, 1751.29015,
    1556.010748, 2158.370577, 2200.194679, 1846.430779, 1977.427947, 2017.924831, 2307.182424, 2387.575063,
    2192.471887, 2214.430787, 2368.540639, 2165.161837, 1915.767307, 2654.724226, 2332.033258, 1723.036311,
    2145.620137, 2440.366115, 2065.739817, 3006.95051, 2152.623157, 2530.930639, 2605.691911, 1911.482088,
    2135.777895, 2415.454168, 2217.36664, 1811.378315, 3054.139064, 2161.265718, 2276.422648, 2494.414188,
    2213.662651, 2123.939662, 2551.003326, 1860.79875, 2031.994091, 2255.120215, 2334.789703, 2131.80478,
    2375.260974, 2100.748012, 2733.887162, 2720.923873, 1987.908351, 2554.891595, 2540.355065, 2449.293485,
    2435.316254, 2531.132379, 2689.386239, 2487.624126, 2181.894195, 2827.193661, 2752.258764, 3279.007336,
    2580.31877, 2578.08621, 2718.790406, 2839.672106, 2482.377636, 2742.936564, 3361.985319, 2451.938286,
    2723.652472, 2605.284815, 3164.751159, 2977.561226, 2919.095822, 3483.681814, 2757.692421, 2899.319914,
    2460.303247, 3390.743102, 3492.745143, 2910.040098, 3359.350231, 3044.815723, 3898.104321, 3210.065533,
    3571.594159, 3484.329545, 3879.1574, 3224.839838, 3136.721911, 3871.350169, 3636.878671, 2942.548833,
    3000.945262, 3378.486216, 3103.639648, 3618.306286, 3326.510975, 3319.897425, 3641.982211, 2796.410192,
    2965.381075, 3028.958747, 2935.070907, 3156.839818, 2754.693764, 2799.420143, 2874.024209, 2821.869027,
    2934.746297, 3224.896646, 3282.17346, 2544.562596, 3117.010935, 2933.546051, 2796.994439, 2879.897837,
    2663.075206, 3273.633506, 3444.042805, 3054.888187, 3270.736694, 3292.534326, 3184.215019, 3228.878501,
    2654.329812, 3121.976357, 3539.051135, 3059.332011, 2942.13803, 2945.558001, 3634.153528, 3557.971786,
    3195.295399, 2923.477021
  ),
  start = c(1972, 1),
  frequency = 12
)


# Reference Values for Regression Tests
# --------------------------------------
# These are expected outputs from tempdisagg v0.24.1 for comparison

# Year to quarter conversion - first 10 values for key methods
reference_y2q <-
  list(
    dencho_p_1 = rep(NA_real_, 10L),
    dencho_p_2 = rep(NA_real_, 10L),
    cl_rss_R = c(
      31.0648296314, 31.376628094, 29.9492852367, 32.3700157927, 32.4855992935,
      32.9370177056, 32.9416949892, 34.2025283839, 39.4907189242, 40.6948442203
    ),
    cl_log = c(
      30.8957937267, 31.2145424609, 29.7518464152, 32.2513261944, 32.3279995961,
      32.8269209836, 32.8317836851, 34.0730685505, 39.4243199059, 40.7028002148
    ),
    fer = c(
      30.6645443975, 30.8809117534, 29.9338961272, 31.5300107504, 31.7254275179,
      31.9913519817, 32.060256688, 33.1479292732, 36.9901490699, 38.153782642
    ),
    lit_rss = c(
      24.3686906726, 24.5556141176, 24.8805391048, 25.0169084874, 25.9365352397,
      26.2217041913, 27.0337754387, 28.6411343647, 30.3927507945, 32.4751826273
    )
  )

# Quarter to month conversion - first 10 values for key methods
reference_q2m <-
  list(
    dencho_p_1 = rep(NA_real_, 10L),
    dencho_p_2 = rep(NA_real_, 10L),
    cl_rss_R = c(
      10.3180800327, 10.1522044102, 11.5193547929, 10.636927362, 10.4999046226,
      11.1754442577, 10.8117721231, 10.0073754759, 9.9693788871, 10.8083334286
    ),
    cl_log = c(
      10.4719212312, 10.305063411, 11.7006461437, 10.8134260502, 10.6428781463,
      11.3455286026, 11.0059032067, 10.1287376864, 10.1226699053, 10.9438170138
    ),
    fer = c(
      10.766518281, 10.6019129351, 11.9999366552, 11.1254221699, 10.9218344627,
      11.6394881791, 11.3326631072, 10.3941167125, 10.4225413312, 11.2073635473
    ),
    lit_rss = c(
      11.40765992, 11.2361792056, 12.6989066457, 11.788044205, 11.5656142196,
      12.3204628141, 12.0090811809, 11.0098790169, 11.049585857, 11.8598712394
    )
  )
