% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{descriptives}
\alias{descriptives}
\title{Describe a dataset}
\usage{
descriptives(x, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{...}{Additional arguments.}
}
\value{
A \code{data.frame} with descriptive statistics for \code{x}.
Its elements are:
\tabular{lll}{
\strong{name} \tab \code{Character} \tab Variable name\cr
\strong{type} \tab \code{character} \tab Data type in \code{R}, as obtained by \code{class(x)[1]}\cr
\strong{n} \tab \code{Integer} \tab Number of valid observations\cr
\strong{missing} \tab \code{Numeric} \tab Proportion missing\cr
\strong{unique} \tab \code{Integer} \tab Number of unique values\cr
\strong{mean} \tab \code{numeric} \tab Mean value of non-missing entries, only defined for variables that can be coerced to numeric\cr
\strong{median} \tab \code{numeric} \tab Median value of non-missing entries, only defined for numeric variables\cr
\strong{mode} \tab \code{Integer} \tab For numeric variables: The mode value. For factors: The frequency of the mode value\cr
\strong{mode_value} \tab \code{Character} \tab For factors: value of the mode\cr
\strong{sd} \tab \code{numeric} \tab Standard deviation of non-missing entries, only defined for variables that can be coerced to numeric\cr
\strong{v} \tab \code{numeric} \tab Variability coefficient V for factor
variables (Agresti, 1990). V is the probability that two independent
observations fall in different categories\cr
\strong{min} \tab \code{numeric} \tab Minimum value for numeric variables\cr
\strong{max} \tab \code{numeric} \tab Maximum value for numeric variables\cr
\strong{range} \tab \code{numeric} \tab Range (distance between min and max) for numeric variables\cr
\strong{skew} \tab \code{numeric} \tab Skewness. The normalized third central moment of a numeric variable, which reflects its skewness. A symmetric distribution has a skewness of zero\cr
\strong{skew_2se} \tab \code{numeric} \tab Skewness, divided by two times its standard error. Values greater than one can be considered "significant" according to a Z-test with significance level of .05\cr
\strong{kurt} \tab \code{numeric} \tab Kurtosis. The normalized fourth central moment of a numeric variable, which reflects its peakedness. A heavy-tailed distribution has high kurtosis, a light-tailed distribution has low kurtosis (sometimes called platykurtic).\cr
\strong{kurt_2se} \tab \code{numeric} \tab Kurtosis, divided by two times its standard error. Values greater than one can be considered "significant" according to a Z-test with significance level of .05
}
}
\description{
Provide descriptive statistics for a dataset.
}
\examples{
descriptives(iris)
}
\references{
Agresti, A. (2012). Categorical data analysis (Vol. 792).
John Wiley & Sons.
}
