% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrema.R
\name{extrema-functions}
\alias{extrema-functions}
\alias{min}
\alias{max}
\title{NA-aware Extrema Functions}
\usage{
min(..., na.rm = TRUE)

max(..., na.rm = TRUE)
}
\arguments{
\item{...}{Numeric or character arguments.}

\item{na.rm}{Logical. Should missing values be removed? Default \code{TRUE}.}
}
\value{
A length-one vector.
}
\description{
Drop-in replacements for \code{min()} and \code{max()} that default to \code{na.rm = TRUE}.
}
\examples{
x <- c(1, NA, 5, 3)
min(x)
max(x)

# Multiple arguments
min(c(5, NA), c(1, 2))

}
