% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArraySchema.R
\name{tiledb_ndim,tiledb_array_schema-method}
\alias{tiledb_ndim,tiledb_array_schema-method}
\title{Return the number of dimensions associated with the \code{tiledb_array_schema}}
\usage{
\S4method{tiledb_ndim}{tiledb_array_schema}(object)
}
\arguments{
\item{object}{A TileDB Schema object}
}
\value{
integer number of dimensions
}
\description{
Return the number of dimensions associated with the \code{tiledb_array_schema}
}
\examples{
\dontshow{
ctx <- tiledb_ctx(limitTileDBCores())
}
dom <- tiledb_domain(dims = c(tiledb_dim("d1", c(1L, 10L), type = "INT32")))
sch <- tiledb_array_schema(dom, attrs = c(
  tiledb_attr("a1", type = "INT32"),
  tiledb_attr("a2", type = "FLOAT64")
))
tiledb_ndim(sch)

}
