% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_by.R
\name{time_by}
\alias{time_by}
\alias{time_tbl_time_col}
\title{Group by a time variable at a higher time unit}
\usage{
time_by(data, time, width = NULL, .name = NULL, .add = TRUE)

time_tbl_time_col(x)
}
\arguments{
\item{data}{A data frame.}

\item{time}{Time variable (\bold{data-masking}). \cr
E.g., a \code{Date}, \code{POSIXt}, \code{numeric} or any time variable.}

\item{width}{A \link{timespan}.}

\item{.name}{An optional glue specification passed to \code{stringr::glue()}
which can be used to concatenate
strings to the time column name or replace it.}

\item{.add}{Should the time groups be added to existing groups?
Default is \code{TRUE}.}

\item{x}{A \code{time_tbl_df}.}
}
\value{
A \code{time_tbl_df} which for practical purposes can be treated the
same way as a dplyr \code{grouped_df}.
}
\description{
\code{time_by} groups a time variable by a specified time unit like
for example "days" or "weeks". \cr
It can be used exactly like \code{dplyr::group_by}.
}
\examples{
library(dplyr)
library(timeplyr)
library(fastplyr)
library(nycflights13)
library(lubridate)

# Basic usage
hourly_flights <- flights |>
  time_by(time_hour) # Detects time granularity

hourly_flights

monthly_flights <- flights |>
  time_by(time_hour, "month")
weekly_flights <- flights |>
  time_by(time_hour, "week")

monthly_flights |>
  f_count()

weekly_flights |>
  f_summarise(n = n(), arr_delay = mean(arr_delay, na.rm = TRUE))

# To aggregate multiple variables, use `time_cut_width`

flights |>
  f_count(week = time_cut_width(time_hour, months(3)))
}
