% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{calculate_weighted_marginals}
\alias{calculate_weighted_marginals}
\title{Calculate Weighted Marginal Distributions}
\usage{
calculate_weighted_marginals(samples)
}
\arguments{
\item{samples}{A data frame containing parameter samples (e.g., \code{log_N}, \code{log_k0})
and a negative log-likelihood column named \code{NLL}.}
}
\value{
A named list where each element is a density object (a list with \code{x}
and \code{y} components) corresponding to a model parameter.
\item{x}{Vector of parameter values}
\item{y}{Vector of density estimates}
}
\description{
Calculates the marginal probability distribution for each model parameter. The
distributions are weighted by the likelihood of each sample, making this useful for
identifying the most probable parameter values from a set of Monte Carlo samples.
}
\details{
This function uses the \code{weighted_kde} helper to perform kernel density
estimation for each parameter, with weights derived from the normalized
likelihoods of the samples.
}
