% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocessing.R
\name{list_to_matrix}
\alias{list_to_matrix}
\title{topolow Data Preprocessing Functions}
\usage{
list_to_matrix(
  data,
  object_col,
  reference_col,
  value_col,
  is_similarity = FALSE
)
}
\arguments{
\item{data}{Data frame in long format with columns for objects, references, and values.}

\item{object_col}{Character. Name of the column containing object identifiers.}

\item{reference_col}{Character. Name of the column containing reference identifiers.}

\item{value_col}{Character. Name of the column containing measurement values.}

\item{is_similarity}{Logical. Whether values are similarities (TRUE) or dissimilarities (FALSE).
If TRUE, similarities will be converted to dissimilarities by subtracting from the
maximum value per reference. Default: FALSE.}
}
\value{
A symmetric matrix of dissimilarities with row and column names corresponding
to the union of unique objects and references in the data. NA values represent
unmeasured pairs, and the diagonal is set to 0.
}
\description{
Converts data from long/list format (one measurement per row) to a symmetric
dissimilarity matrix. The function handles both similarity and dissimilarity
data, with optional conversion from similarity to dissimilarity.
}
\details{
Convert List Format Data to Dissimilarity Matrix

The function expects data in long format with at least three columns:
\itemize{
\item A column for object names
\item A column for reference names
\item A column containing the (dis)similarity values
}

When \code{is_similarity = TRUE}, the function converts similarities to dissimilarities
by subtracting each similarity value from the maximum similarity value within
each reference group. Threshold indicators (< or >) are handled appropriately
and inverted during similarity-to-dissimilarity conversion.
}
\examples{
# Example with dissimilarity data
data_dissim <- data.frame(
  object = c("A", "B", "A", "C"),
  reference = c("X", "X", "Y", "Y"),
  dissimilarity = c(2.5, 1.8, 3.0, 4.2)
)

mat_dissim <- list_to_matrix(
  data = data_dissim,
  object_col = "object",
  reference_col = "reference",
  value_col = "dissimilarity",
  is_similarity = FALSE
)

# Example with similarity data (will be converted to dissimilarity)
data_sim <- data.frame(
  object = c("A", "B", "A", "C"),
  reference = c("X", "X", "Y", "Y"),
  similarity = c(7.5, 8.2, 7.0, 5.8)
)

mat_from_sim <- list_to_matrix(
  data = data_sim,
  object_col = "object",
  reference_col = "reference",
  value_col = "similarity",
  is_similarity = TRUE
)

}
