% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuda.R
\name{cuda_memory_stats}
\alias{cuda_memory_stats}
\alias{cuda_memory_summary}
\title{Returns a dictionary of CUDA memory allocator statistics for a given device.}
\usage{
cuda_memory_stats(device = cuda_current_device())

cuda_memory_summary(device = cuda_current_device())
}
\arguments{
\item{device}{Integer value of the CUDA device to return capabilities of.}
}
\description{
The return value of this function is a dictionary of statistics, each of which
is a non-negative integer.
}
\section{Core statistics}{

\itemize{
\item "allocated.\{all,large_pool,small_pool\}.\{current,peak,allocated,freed\}": number of allocation requests received by the memory allocator.
\item "allocated_bytes.\{all,large_pool,small_pool\}.\{current,peak,allocated,freed\}": amount of allocated memory.
\item "segment.\{all,large_pool,small_pool\}.\{current,peak,allocated,freed\}": number of reserved segments from cudaMalloc().
\item "reserved_bytes.\{all,large_pool,small_pool\}.\{current,peak,allocated,freed\}": amount of reserved memory.
\item "active.\{all,large_pool,small_pool\}.\{current,peak,allocated,freed\}": number of active memory blocks.
\item "active_bytes.\{all,large_pool,small_pool\}.\{current,peak,allocated,freed\}": amount of active memory.
\item "inactive_split.\{all,large_pool,small_pool\}.\{current,peak,allocated,freed\}": number of inactive, non-releasable memory blocks.
\item "inactive_split_bytes.\{all,large_pool,small_pool\}.\{current,peak,allocated,freed\}": amount of inactive, non-releasable memory.
}

For these core statistics, values are broken down as follows.

Pool type:
\itemize{
\item all: combined statistics across all memory pools.
\item large_pool: statistics for the large allocation pool (as of October 2019, for size >= 1MB allocations).
\item small_pool: statistics for the small allocation pool (as of October 2019, for size < 1MB allocations).
}

Metric type:
\itemize{
\item current: current value of this metric.
\item peak: maximum value of this metric.
\item allocated: historical total increase in this metric.
\item freed: historical total decrease in this metric.
}
}

\section{Additional metrics}{

\itemize{
\item "num_alloc_retries": number of failed cudaMalloc calls that result in a cache flush and retry.
\item "num_ooms": number of out-of-memory errors thrown.
}
}

