% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power2MixedCountContinuous.R
\name{power2MixedCountContinuous}
\alias{power2MixedCountContinuous}
\title{Power Calculation for Two Co-Primary Endpoints (Count and Continuous)}
\usage{
power2MixedCountContinuous(
  n1,
  n2,
  r1,
  r2,
  nu,
  t,
  mu1,
  mu2,
  sd,
  rho1,
  rho2,
  alpha
)
}
\arguments{
\item{n1}{Sample size for group 1 (test group)}

\item{n2}{Sample size for group 2 (control group)}

\item{r1}{Mean rate (events per unit time) for the treatment group (count endpoint)}

\item{r2}{Mean rate (events per unit time) for the control group (count endpoint)}

\item{nu}{Common dispersion parameter for the negative binomial distribution (nu > 0)}

\item{t}{Common follow-up time period}

\item{mu1}{Mean for group 1 (continuous endpoint)}

\item{mu2}{Mean for group 2 (continuous endpoint)}

\item{sd}{Common standard deviation for the continuous endpoint}

\item{rho1}{Correlation between count and continuous outcomes for treatment group}

\item{rho2}{Correlation between count and continuous outcomes for control group}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}
}
\value{
A data frame with the following columns:
\item{n1}{Sample size for group 1}
\item{n2}{Sample size for group 2}
\item{r1}{Mean rate in group 1 for count endpoint}
\item{r2}{Mean rate in group 2 for count endpoint}
\item{nu}{Dispersion parameter}
\item{t}{Follow-up time}
\item{mu1}{Mean in group 1 for continuous endpoint}
\item{mu2}{Mean in group 2 for continuous endpoint}
\item{sd}{Standard deviation for continuous endpoint}
\item{rho1}{Correlation for group 1}
\item{rho2}{Correlation for group 2}
\item{alpha}{One-sided significance level}
\item{powerCount}{Power for the count endpoint alone}
\item{powerCont}{Power for the continuous endpoint alone}
\item{powerCoprimary}{Power for both co-primary endpoints}
}
\description{
Calculates the power for a two-arm superiority trial with one overdispersed
count co-primary endpoint and one continuous co-primary endpoint, as described
in Homma and Yoshida (2024).
}
\details{
The test statistics are (equation 7 in Homma and Yoshida 2024):
\deqn{Z_1 = \frac{\hat{\beta}_1}{\sqrt{Var(\hat{\beta}_1)}}, \quad
      Z_2 = \frac{\hat{\delta}}{\sigma\sqrt{(1+\kappa)/(\kappa n_0)}}}

The joint distribution of (Z1, Z2) follows an asymptotic bivariate normal
distribution with correlation gamma (equation 11):
\deqn{\gamma = \sum_{j=0,1} \frac{n_0 \rho_j \sqrt{1+\lambda_j/\nu}}
      {n_j \sqrt{\lambda_j V_a} \sqrt{(1+\kappa)/\kappa}}}

where \eqn{\lambda_j = r_j \times t}.

The correlation bounds are automatically checked using \code{\link{corrbound2MixedCountContinuous}}.
}
\examples{
# Power calculation with moderate correlation
power2MixedCountContinuous(
  n1 = 300,
  n2 = 300,
  r1 = 1.0,
  r2 = 1.25,
  nu = 0.8,
  t = 1,
  mu1 = -50,
  mu2 = 0,
  sd = 250,
  rho1 = 0.5,
  rho2 = 0.5,
  alpha = 0.025
)

# Power calculation with no correlation
power2MixedCountContinuous(
  n1 = 350,
  n2 = 350,
  r1 = 1.0,
  r2 = 1.5,
  nu = 1,
  t = 1,
  mu1 = -40,
  mu2 = 0,
  sd = 200,
  rho1 = 0,
  rho2 = 0,
  alpha = 0.025
)

# Unbalanced design
power2MixedCountContinuous(
  n1 = 400,
  n2 = 200,
  r1 = 1,
  r2 = 1.25,
  nu = 1,
  t = 1,
  mu1 = -50,
  mu2 = 0,
  sd = 250,
  rho1 = 0.6,
  rho2 = 0.6,
  alpha = 0.025
)

}
\references{
Homma, G., & Yoshida, T. (2024). Sample size calculation in clinical trials
with two co-primary endpoints including overdispersed count and continuous
outcomes. \emph{Pharmaceutical Statistics}, 23(1), 46-59.
}
