% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_ms.R
\name{uplot_ms}
\alias{uplot_ms}
\title{Plot Mass Spectrum}
\usage{
uplot_ms(
  pl,
  mass = "mz",
  peak_magnitude = "i_magnitude",
  label = "file_id",
  logo = FALSE,
  plotly = TRUE,
  data_reduction = 1,
  ...
)
}
\arguments{
\item{pl}{A data table that must contain columns for mass-to-charge ratio and peak magnitude (could be peak list or molecular formula data).}

\item{mass}{Character. Name of the column containing mass-to-charge or mass information (default = "mz").}

\item{peak_magnitude}{Character. Name of the column containing (relative) peak magnitude information (default = "i_magnitude").}

\item{label}{Character. Name of the column containing the names of the mass spectra to be displayed (default = "file_id").}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{data_reduction}{Numeric. The percentage of the most abundant peaks to select per spectrum.
This value should be between 0 and 1 (default = 1, which means all data will be displayed).
If set to 0, no data reduction will occur, but a minimum value of 0.01 will be used to ensure some data is displayed.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A ggplot (class "ggplot") or plotly (class "htmlwidget") object
representing the mass spectrum.
}
\description{
Plots the mass spectrum, showing magnitude versus mass-to-charge ratio (m/z).
Optionally reduces the data by selecting the top \code{data_reduction} most abundant peaks per spectrum.
}
\examples{
uplot_ms(pl = peaklist_demo, data_reduction = 0.1, plotly = TRUE)
uplot_ms(pl = peaklist_demo, data_reduction = 1, plotly = FALSE)
}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_heteroatoms}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
