% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FU_Berlin.R
\docType{data}
\name{fu_4}
\alias{fu_4}
\title{Additional colors of the Free University (FU) Berlin, Germany}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the \href{https://www.fu-berlin.de/en/index.html}{FU}'s 
\href{https://www.fu-berlin.de/sites/corporate-design/}{CI} page.
}
\usage{
fu_4
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{fu_4} provides four additional colors   
of the \href{https://www.fu-berlin.de/en/index.html}{Free University Berlin}, Germany.
}
\details{
The color values were updated in 2024.
}
\examples{
fu_4
unikn::seecol(fu_4, main = "Additional colors of the FU Berlin")  # view palette

}
\seealso{
\code{\link{fu_1}} for the two primary colors of the FU Berlin;
\code{\link{fu_2}} for the black color gradient of the FU Berlin;
\code{\link{fu_3}} for the blue color gradient of the FU Berlin; 
\code{\link{fu_0_2023}} for older colors of the FU Berlin (pre 2024);
\code{\link{fu_1_2023}} for older color gradient of the FU Berlin (pre 2024);
\code{\link[unikn]{seecol}} for viewing and comparing color palettes; 
\code{\link[unikn]{usecol}} for using color palettes; 
\code{\link[unikn]{simcol}} for finding similar colors; 
\code{\link[unikn]{newpal}} for defining new color palettes; 
\code{\link[unikn]{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0_2023}},
\code{\link{fu_1}},
\code{\link{fu_1_2023}},
\code{\link{fu_2}},
\code{\link{fu_2_2023}},
\code{\link{fu_3}},
\code{\link{fu_3_2023}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2024-05-06.
}
\concept{German university color palettes}
\keyword{datasets}
