% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cork.R
\docType{data}
\name{ucc_1}
\alias{ucc_1}
\title{Primary colours of the University College Cork, Ireland}
\format{
An object of class \code{character} of length 6.
}
\source{
Color definitions are based on \href{https://www.ucc.ie/en/}{UCC}'s 
\href{https://www.ucc.ie/en/marketing-brand/}{Visual identity guidelines} (PDF of 2017, p. 26f.).
}
\usage{
ucc_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{ucc_1} provides the six primary colours 
of the \href{https://www.ucc.ie/en/}{University College Cork}, Ireland.
}
\details{
The 6 primary colours are 
\code{Crest yellow}, defined as Pantone 7549C, C0 M20 Y100 K0, R255 G181 B0, or HEX "#FFB500", 
\code{Crest red}, defined as Pantone 1795C, C0 M96 Y90 K2, R206 G31 B44, or HEX "#CE1F2C", 
\code{Crest blue}, defined as Pantone 2955C, C100 M45 Y10 K37, R0 G60 B105, or HEX "#003C69", 
\code{Crest black}, defined as "black", Pantone Black, C0 M0 Y0 K100, R0 G0 B0, or HEX "#000000", 
\code{Crest white}, defined as "white", C0 M0 Y0 K0, R255 G255 B255, or HEX "#FFFFFF", and  
\code{Crest black tint}, defined as C0 M0 Y0 K6, R239 G239 B240, or HEX "#EFEFF0".

\code{ucc_1} uses the HEX color definitions.


These colours are to be used at a university level 
(on both coated and uncoated paper).

Colour plays an important part in \href{https://www.ucc.ie/en/}{UCC}'s identity and 
renders all communications consistent and cohesive.

The primary colour palette uses the four colours from the crest.

In all communications the bold use of white space is a key element 
of \href{https://www.ucc.ie/en/}{UCC}'s use of colour. 
When choosing a colour to complement photography, care should be taken 
to ensure it is compatible.

Please do not use tints of the colours except on the colours indicated.
}
\examples{
ucc_1
unikn::seecol(ucc_1, col_bg = "grey90", 
              main = "Primary colours of the University College Cork") # view palette
              
}
\seealso{
\code{\link{ucc_2}} for secondary colours of the University College Cork;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{limerick_1}},
\code{\link{limerick_2}},
\code{\link{maynooth}},
\code{\link{trinity_1}},
\code{\link{trinity_2}},
\code{\link{ucc_2}},
\code{\link{ucd}}
}
\author{
\strong{unicol}, 2023-09-09.
}
\concept{Irish university color palettes}
\keyword{datasets}
