% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aberystwyth.R
\docType{data}
\name{aberystwyth_2}
\alias{aberystwyth_2}
\title{Secondary corporate colors of Aberystwyth University, Wales}
\format{
An object of class \code{character} of length 6.
}
\source{
\href{https://aber.ac.uk/en/}{Aberystwyth University}'s 
\href{https://www.aber.ac.uk/en/gmsr/brand/colours-fonts/}{Corporate colours}.
}
\usage{
aberystwyth_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{aberystwyth_2} provides the six secondary corporate colours 
of \href{https://aber.ac.uk/en/}{Aberystwyth University}, Wales, UK.
}
\details{
\code{aberystwyth_2} uses the HEX color definitions 
(see \href{https://aber.ac.uk/en/}{Aberystwyth University}'s 
\href{https://www.aber.ac.uk/en/gmsr/brand/colours-fonts/}{Corporate colour page} 
for details and alternative definitions).


To support the primary colours, the secondary colours of  
\href{https://aber.ac.uk/en/}{Aberystwyth University} 
are alternatives providing flexibility and freedom for the design team.

Careful consideration and permission is required for use of any 
of the secondary colours over the primary colours.
}
\examples{
aberystwyth_2
unikn::seecol(aberystwyth_2, main = "Secondary colours of Aberystwyth University") # view colours

}
\seealso{
\code{\link{aberystwyth_1}} for primary colours of Aberystwyth University;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Welsh university color palettes: 
\code{\link{aberystwyth_1}},
\code{\link{bangor_1}},
\code{\link{bangor_2}},
\code{\link{bangor_3}},
\code{\link{bangor_4}},
\code{\link{cardiff_1}},
\code{\link{cardiff_2}}
}
\author{
\strong{unicol}, 2023-09-11.
}
\concept{Welsh university color palettes}
\keyword{datasets}
