% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lisbon.R
\docType{data}
\name{uni_lisbon}
\alias{uni_lisbon}
\title{Colors of the University of Lisbon, Portugal}
\format{
An object of class \code{character} of length 2.
}
\source{
Color definitions are based on ULisboa's  
\href{https://www.ulisboa.pt/info/identidade}{Manual normas graficas (PDF)}.
}
\usage{
uni_lisbon
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_lisbon} provides the two basic (and monochromatic) colors 
of the \href{https://www.ulisboa.pt}{University of Lisbon}, Portugal.
}
\details{
The 2 primary colors are 
\code{"black"} (corresponding to RGB \code{0 0 0} and HEX \code{"#000000"}) and 
\code{"white"} (corresponding to RGB \code{255 255 255} and HEX \code{"#FFFFFF"}).  

\code{uni_lisbon} is defined by R color names.
}
\examples{
uni_lisbon
unikn::seecol(uni_lisbon, col_bg = "lightgrey",  
              main = "Colors of the University of Lisbon")  # view color palette
unikn::demopal(uni_lisbon, main = "Universidade de Lisboa") # demo color palette 

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.
}
\author{
P. M. Santos to \strong{unicol}, 2023-08-17.
}
\concept{Portuguese university color palettes}
\keyword{datasets}
