% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/air.R
\name{use_air}
\alias{use_air}
\title{Configure a project to use Air}
\usage{
use_air(vscode = TRUE)
}
\arguments{
\item{vscode}{Either:
\itemize{
\item \code{TRUE} to set up VS Code and Positron specific Air settings. This is the
default.
\item \code{FALSE} to opt out of those settings.
}}
}
\description{
\href{https://posit-dev.github.io/air/}{Air} is an extremely fast R code
formatter. This function sets up a project to use Air. Specifically, it:
\itemize{
\item Creates an empty \code{air.toml} configuration file. If either an \code{air.toml} or
\code{.air.toml} file already existed, nothing is changed. If the project is an
R package, \code{.Rbuildignore} is updated to ignore this file.
\item Creates a \verb{.vscode/} directory and adds recommended settings to
\code{.vscode/settings.json} and \code{.vscode/extensions.json}. These settings are
used by the Air extension installed through either VS Code or Positron, see
the Installation section for more details. Specifically it:
\itemize{
\item Sets \code{editor.formatOnSave = true} for R and Quarto files to enable
formatting on every save.
\item Sets \code{editor.defaultFormatter} to Air for R files to ensure that Air is
always selected as the formatter for this project. Likewise, sets the
default formatter for Quarto.
\item Sets the Air extension as a "recommended" extension for this project,
which triggers a notification for contributors coming to this project
that don't yet have the Air extension installed.
}

If the project is an R package, \code{.Rbuildignore} is updated to ignore the
\verb{.vscode/} directory.

If you'd like to opt out of VS Code / Positron specific setup, set \code{vscode = FALSE}, but remember that even if you work in RStudio, other contributors
may prefer another editor.
}

Note that "using Air" breaks down into a few steps, and \code{use_air()} does
\emph{one} of them. Here's an overview:
\itemize{
\item Installation: Air might already be included in your IDE (e.g. Positron) or
can be added as an external formatter (e.g. RStudio) or as an extension
(e.g. VS Code). Read the guide that applies to your situation:
\itemize{
\item \href{https://posit-dev.github.io/air/editors.html}{Air in an editor}
\item \href{https://posit-dev.github.io/air/cli.html}{Air at the command line}
}
\item Configuration: \code{use_air()} does this!
\item Invocation: There are many ways to run Air. In an IDE, you can expect
support for moves like "format on save", "format selection", and so on.
At the command line, you can format individual files or entire directories.
\item Continuous integration: Two workflows are available for running Air via
GitHub Actions: \code{format-suggest} or \code{format-check}. Learn more in
\href{https://posit-dev.github.io/air/integration-github-actions.html}{Air's documentation of its GHA integrations}.
You can set up either workflow in your project like so:

\if{html}{\out{<div class="sourceCode">}}\preformatted{use_github_action(url = "https://github.com/posit-dev/setup-air/blob/main/examples/format-suggest.yaml")
use_github_action(url = "https://github.com/posit-dev/setup-air/blob/main/examples/format-check.yaml")
}\if{html}{\out{</div>}}
}
}
\examples{
\dontrun{
# Prepare an R package or project to use Air
use_air()
}
}
