% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_averted_by_vaccination.R
\name{compute_events_averted_by_vaccination}
\alias{compute_events_averted_by_vaccination}
\title{Compute events averted by vaccination}
\usage{
compute_events_averted_by_vaccination(
  number_of_events,
  cumulative_coverage,
  vaccine_effectiveness
)
}
\arguments{
\item{number_of_events}{number of events}

\item{cumulative_coverage}{cumulative vaccination coverage}

\item{vaccine_effectiveness}{vaccine effectiveness}
}
\value{
estimated number of events averted
}
\description{
Compute events averted by vaccination
}
\details{
The number of events averted by vaccination is calculated as described by Machado et al. (2019) \url{doi:10.2807/1560-7917.ES.2019.24.45.1900268}.
}
\examples{
data(coverage_and_incidence_mock_data)
data(ve_mock_data)
coverage <- coverage_and_incidence_mock_data$coverage_data
incidence <- coverage_and_incidence_mock_data$incidence_data
vaccine_effectiveness <- ve_mock_data$ve
nae <- compute_events_averted_by_vaccination(
  number_of_events = incidence$events,
  cumulative_coverage = coverage$cumulative_coverage,
  vaccine_effectiveness = vaccine_effectiveness
)
plot(nae, type = "l", xlab = "Time", ylab = "Events averted")
}
