% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_comparison.R
\name{generate_analysis_summary}
\alias{generate_analysis_summary}
\title{Generate Comprehensive Analysis Summary}
\usage{
generate_analysis_summary(
  comparison_table,
  cv_summary = NULL,
  break_results = NULL,
  cca_results = NULL,
  granger_results = NULL
)
}
\arguments{
\item{comparison_table}{Data frame from compare_models.}

\item{cv_summary}{Data frame from summarize_cv_results (or NULL).}

\item{break_results}{Result from test_structural_breaks (or NULL).}

\item{cca_results}{Result from run_sparse_cca (or NULL).}

\item{granger_results}{Data frame from panel_granger_test (or NULL).}
}
\value{
A list with formatted summary components.
}
\description{
Creates a complete summary of all analysis results including models,
validation, and structural break tests.
}
\examples{
comparison <- data.frame(
  model = c("Model A", "Model B"),
  R2 = c(0.95, 0.92),
  RMSE_log = c(0.05, 0.06)
)
summary_list <- generate_analysis_summary(comparison)
print(summary_list$best_model)

}
