% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{p_to_symbol}
\alias{p_to_symbol}
\title{Get standard significance symbols from p-values}
\usage{
p_to_symbol(
  p_values,
  symbols = c("***", "**", "*", "ns"),
  breaks = c(0, 0.001, 0.01, 0.05, 1)
)
}
\arguments{
\item{p_values}{Numeric vector of p-values}

\item{symbols}{Character vector of symbols for different significance levels.
Default: c("***", "**", "*", "ns")}

\item{breaks}{Numeric vector of p-value thresholds.
Default: c(0, 0.001, 0.01, 0.05, 1)}
}
\value{
Character vector of significance symbols
}
\description{
Convert p-values to standard significance symbols
}
\examples{
p_to_symbol(c(0.0001, 0.005, 0.03, 0.15))
# Returns: "***"  "**"   "*"    "ns"
}
