% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solid_xyz3d.R
\name{solid_xyz3d}
\alias{solid_xyz3d}
\title{Solid defined by bounds in x, y and z}
\usage{
solid_xyz3d(
  H1,
  H2,
  G1,
  G2,
  a,
  b,
  plot = TRUE,
  n_x = 120,
  n_u = 60,
  n_v = 60,
  mode = c("faces", "wireframe", "both"),
  show_faces = c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE),
  colorscales = c("Blues", "Blues", "Greens", "Greens", "Reds", "Reds"),
  opacities = 0.35,
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  show_edges = TRUE,
  edge_line = list(color = "black", width = 2),
  wire_step = 6,
  wire_line = list(color = "black", width = 1),
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white"),
  compute_volume = FALSE,
  vol_method = c("adaptive", "grid"),
  nx_vol = 300,
  ny_vol = 300,
  slice = list(x = NULL, y = NULL, z = NULL),
  slice_mode = c("surface", "wireframe", "both"),
  slice_nx = 200,
  slice_nu = 120,
  slice_nv = 120,
  slice_colorscales = list(x = "Oranges", y = "Purples", z = "Greens"),
  slice_opacity = 0.55,
  slice_show_grid = TRUE,
  slice_grid_color = "rgba(80,80,80,0.25)",
  slice_grid_width = 1,
  slice_wire_step = 8,
  slice_wire_line = list(color = "black", width = 2, dash = "dot")
)
}
\arguments{
\item{H1, H2}{Functions of one variable \code{x} giving the lower and
upper bounds in the \code{y} direction.}

\item{G1, G2}{Functions of two variables \code{x} y \code{y} giving the
lower and upper bounds in the \code{z} direction.}

\item{a, b}{Numeric endpoints of the interval for \code{x}. It is assumed
that \code{b > a}.}

\item{plot}{Logical; if \code{TRUE}, the solid is rendered with
\pkg{plotly}.}

\item{n_x, n_u, n_v}{Integers giving the mesh resolution in the principal
parameter along \code{x} and in the two internal parameters of the face
meshes.}

\item{mode}{Character string; one of \code{"faces"}, \code{"wireframe"}
or \code{"both"}, indicating whether to draw surfaces, wireframe, or a
combination of both.}

\item{show_faces}{Logical vector indicating which of the six faces to
display. The order is \code{c("x=a","x=b","y=H1","y=H2","z=G1","z=G2")}.
A single logical value is also allowed and will be recycled.}

\item{colorscales}{Color specification for faces. It can be:
\itemize{
\item a single \pkg{plotly} colorscale name applied to all faces,
\item a single flat color (R color name, hexadecimal code, or
\code{"rgba(...)"}),
\item a vector of colors that define a gradient,
\item or a list or vector of length six, assigning a scale or color
specification to each face separately.
}}

\item{opacities}{Numeric values controlling face opacity; may be a single
value or a vector of length six.}

\item{show_surface_grid}{Logical; if \code{TRUE}, draws grid lines on the
faces.}

\item{surface_grid_color, surface_grid_width}{Color and width for surface
grid lines.}

\item{show_edges}{Logical; if \code{TRUE}, draws the edges of each face.}

\item{edge_line}{List with style options for edges (for example, color,
width and dash pattern).}

\item{wire_step}{Integer greater or equal to one; controls how many mesh
lines are skipped between wireframe lines.}

\item{wire_line}{List with style options for wireframe lines.}

\item{scene}{List with 3D scene options for \pkg{plotly}. By default, an
aspect ratio based on the data is used.}

\item{bg}{List specifying background colors for the figure, typically
with entries \code{paper} and \code{plot}.}

\item{compute_volume}{Logical; if \code{TRUE}, computes an approximate
volume of the solid.}

\item{vol_method}{Character string selecting the volume integration
method: \code{"adaptive"} for nested calls to \code{stats::integrate},
or \code{"grid"} for a trapezoidal rule on a regular grid.}

\item{nx_vol, ny_vol}{Integer grid sizes used when
\code{vol_method = "grid"}.}

\item{slice}{List describing slices to be drawn, with components
\code{x}, \code{y} y \code{z}. Each component can be \code{NULL}, a
single numeric value or a numeric vector of slice positions. (Reserved
for future use; currently ignored.)}

\item{slice_mode}{Character string indicating how to render slices:
\code{"surface"}, \code{"wireframe"} or \code{"both"}. (Reserved for
future use; currently ignored.)}

\item{slice_nx, slice_nu, slice_nv}{Mesh resolutions used to build the
slices. (Reserved for future use; currently ignored.)}

\item{slice_colorscales}{List with color scales for slices in the
\code{x}, \code{y} y \code{z} directions, in the same formats accepted
by \code{colorscales}. (Reserved for future use; currently ignored.)}

\item{slice_opacity}{Numeric opacity for slices, between 0 and 1.
(Reserved for future use; currently ignored.)}

\item{slice_show_grid}{Logical; if \code{TRUE}, draws grid lines on the
slices. (Reserved for future use; currently ignored.)}

\item{slice_grid_color, slice_grid_width}{Color and width for slice grid
lines. (Reserved for future use; currently ignored.)}

\item{slice_wire_step}{Integer controlling the spacing of wireframe
lines on slices. (Reserved for future use; currently ignored.)}

\item{slice_wire_line}{List with style options for slice wireframe
lines. (Reserved for future use; currently ignored.)}
}
\value{
A list with:
\itemize{
\item \code{x_seq}, \code{u_seq}, \code{v_seq}: the parameter sequences
used to build the mesh,
\item \code{fig}: a \pkg{plotly} object when \code{plot = TRUE},
otherwise \code{NULL},
\item \code{volume}: either \code{NULL} or a list with an approximate
volume estimate and related metadata when
\code{compute_volume = TRUE}.
}
}
\description{
Constructs a three-dimensional solid defined by bounds in the variables
\code{x}, \code{y} y \code{z}, and optionally renders it using
\pkg{plotly}. The solid is described by:
\itemize{
\item an interval for \code{x} between \code{a} y \code{b},
\item lower and upper functions in the \code{y} direction,
\item lower and upper functions in the \code{z} direction that may
depend on both \code{x} y \code{y}.
}
The function uses a curvilinear-prism parametrization to build meshes for
the six faces of the solid. It supports different display modes (faces,
wireframe, or both), optional numerical volume computation, and internal
slices on coordinate planes (slice arguments are reserved for future
extensions and are currently ignored).
}
\details{
The solid is sampled on a three-parameter grid. Two of the parameters
describe the position on the base region in the \code{x}-\code{y} plane,
and the third parameter interpolates between the lower and upper
\code{z} bounds. From this parametrization the function constructs the
six bounding faces, corresponding to the two extreme values of \code{x},
the two extreme values of \code{y}, and the two extreme values of
\code{z}.

Rendering options allow:
\itemize{
\item drawing only the faces of the solid,
\item drawing only a wireframe of the mesh,
\item combining both faces and wireframe,
\item assigning individual color scales and opacities to each face,
\item showing or hiding surface grids and edges.
}

When internal slices are requested, the intention is to intersect the solid
with planes of the form \code{x = constant}, \code{y = constant} o
\code{z = constant}. The corresponding slice arguments are reserved for
future versions of the function and are not yet implemented.

If \code{compute_volume = TRUE}, the function also computes an
approximate volume of the solid using either:
\itemize{
\item a nested adaptive integration based on \code{stats::integrate},
\item or a trapezoidal rule on a regular grid in the \code{x} y
\code{y} directions.
}
}
\examples{
# Note: examples avoid plotting for CRAN checks
H1 <- function(x) -1 - x
H2 <- function(x)  1 - x^2
G1 <- function(x, y) y
G2 <- function(x, y) y + 1
s <- solid_xyz3d(
  H1, H2, G1, G2,
  a = -1, b = 1,
  plot = FALSE,
  compute_volume = TRUE,
  vol_method = "grid",
  nx_vol = 50, ny_vol = 50
)
s$volume$estimate

}
