% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain_report.R
\name{domain_report}
\alias{domain_report}
\title{Get Domain Report}
\usage{
domain_report(domain, ...)
}
\arguments{
\item{domain}{Domain name (character string). Required.}

\item{\dots}{Additional arguments passed to \code{\link{virustotal_GET}}}
}
\value{
A \code{virustotal_domain_report} object containing domain analysis
results including WHOIS data, DNS resolutions, detected URLs, categories,
and threat intelligence
}
\description{
Retrieves comprehensive analysis report for a given domain, including
WHOIS information, DNS resolutions, detected URLs, and threat intelligence
data.
}
\examples{
\dontrun{
# Set API key first
set_key('your_api_key_here')

# Get domain reports
report1 <- domain_report("google.com")
report2 <- domain_report("https://www.example.com/path")

print(report1)
summary(report1)
}
}
\references{
\url{https://docs.virustotal.com/reference/domains}
}
\seealso{
\code{\link{set_key}} for setting the API key
}
\concept{domain operations}
