% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/security.R
\name{sanitize_hash}
\alias{sanitize_hash}
\title{Sanitize hash input}
\usage{
sanitize_hash(hash)
}
\arguments{
\item{hash}{Character string representing a file hash}
}
\value{
Sanitized hash or throws error if invalid
}
\description{
Validates hash inputs to ensure they conform to expected formats
(MD5, SHA1, SHA256) and contain only valid hexadecimal characters.
}
\seealso{
Other security: 
\code{\link{is_api_key_configured}()},
\code{\link{sanitize_domain}()},
\code{\link{sanitize_file_path}()},
\code{\link{sanitize_ip}()},
\code{\link{sanitize_url}()},
\code{\link{security-utilities}}
}
\concept{security}
\keyword{internal}
