% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{seq_knots}
\alias{seq_knots}
\title{Produce a sequence of knots}
\usage{
seq_knots(lo, hi, N, endpoints = FALSE)
}
\arguments{
\item{lo}{Left endpoint; must be finite.}

\item{hi}{Right endpoint; must be finite.}

\item{N}{Number of desired intervals.}

\item{endpoints}{logical; if \code{TRUE}, include the endpoints.}
}
\value{
A vector that represents a sequence of knots. If \code{endpoints = TRUE}, it
contains \eqn{N+1} evenly-spaced knots that represent \eqn{N} regions with
endpoints included. If \code{endpoints = FALSE}, the endpoints are excluded.
}
\description{
Produce knots which define \eqn{N} equally-spaced intervals between
(finite) endpoints \code{lo} and \code{hi}.
}
\examples{
seq_knots(0, 1, N = 5)
seq_knots(0, 1, N = 5, endpoints = TRUE)

# Trivial case: make endpoints for just one interval
seq_knots(0, 1, N = 1)
seq_knots(0, 1, N = 1, endpoints = TRUE)

# The following calls throw errors
tryCatch({
  seq_knots(0, 1, N = 0)
}, error = function(e) { print(e) })
tryCatch({
  seq_knots(0, Inf, N = 5)
}, error = function(e) { print(e) })
tryCatch({
  seq_knots(-Inf, 1, N = 5)
}, error = function(e) { print(e) })

}
