% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layer_functions.R
\name{get_watershed_layer}
\alias{get_watershed_layer}
\title{Retrieve a watershed polygon}
\usage{
get_watershed_layer(
  watershed_code = NULL,
  watershed_name = NULL,
  county = NULL,
  sf_object = NULL,
  huc_level = NULL,
  where = NULL,
  ...
)
}
\arguments{
\item{watershed_code}{A character object specifying the HUC code for a
watershed}

\item{watershed_name}{A character object specifying the HUC name for a
watershed}

\item{county}{A character object specifying a county name}

\item{sf_object}{Any sf polygon object}

\item{huc_level}{"HUC_8","HUC_10", or "HUC_12"}

\item{where}{SQL statement}

\item{...}{Additional parameters that are passed to
\code{\link[arcpullr]{get_spatial_layer}}}
}
\value{
A sf polygon object
}
\description{
This function will retrieve a watershed boundary from WDNR's ArcGIS Rest
Services. A subbasin (HUC8), watershed (HUC 10), or subwatershed (HUC 12) can
be retrieved by passing the HUC code or name as a character string.
See watershed_lookup for a full list of HUC codes and names.
Use filter_huc() to see watersheds by county or
classification level.
}
\details{
A function to retrieve a watershed boundary from WDNR's
subbasin (HUC8), watershed (HUC 10), or subwatershed (HUC 12) spatial layers.
Use 'watershed_lookup' to see a full list of available HUC codes and names.
}
\examples{
\dontrun{
get_watershed_layer(watershed_code = "07070006")
get_watershed_layer(watershed_name = "Kickapoo")
get_watershed_layer(county = "forest",huc_level = "HUC_12")
}
}
