% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thermaltime_hourly.R
\name{tt_hourly_pp}
\alias{tt_hourly_pp}
\title{Hourly Air Temperature Interpolation}
\usage{
tt_hourly_pp(tmin, tmax, tmax_b, tmin_a, lat, doy)
}
\arguments{
\item{tmin}{Numeric. Minimum temperature of the day (°C).}

\item{tmax}{Numeric. Maximum temperature of the day (°C).}

\item{tmax_b}{Numeric. Maximum temperature from the previous day (°C).}

\item{tmin_a}{Numeric. Minimum temperature of the following day (°C).}

\item{lat}{Numeric. Latitude of the location (degrees, -90 to 90).}

\item{doy}{Integer. Day of the year (1 to 366).}
}
\value{
A numeric vector of length 24 containing the estimated hourly air temperatures (°C).
}
\description{
Computes hourly estimates of air temperature (Ta) from daily Tmin, Tmax, and day length
using the method of Goudriaan (1994). The function assumes a sinusoidal temperature variation during
daylight hours and an exponential decay after sunset.
}
\details{
- **Daytime interpolation**: During sunlight hours, Ta is estimated using a sinusoidal curve fitted between Tmin and Tmax.
- **Nighttime interpolation**: After sunset, Ta follows an exponential decline from the sunset temperature to the next morning's Tmin.
- **Sunrise and Sunset Calculation**: 
  - Sunrise hour: `hsrise = 12 - d/2`
  - Sunset hour: `hsset = 12 + d/2`
  - Tmax occurs at hour = 13.5.

If the Controlled Environment module is used for weather data, the function takes hourly values from that instead of computing them.
}
\examples{
tmin <- 10
tmax <- 20
tmax_b <- 21
tmin_a <- 11
lat <- -27
doy <- 10
hourly_temps <- tt_hourly_pp(tmin, tmax, tmax_b, tmin_a, lat, doy)

}
\references{
Goudriaan, J. (1994). Advanced Methods for Calculating Radiation Models. 
            Netherlands Journal of Agricultural Science, 42(4), 315-323.
}
