% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printGM.R
\name{printGM}
\alias{printGM}
\title{Print Formatted SEM Model Syntax}
\usage{
printGM(x, ...)
}
\arguments{
\item{x}{A list or character string containing SEM model syntax.
If \code{x} is a \code{wsMed()} result, it will extract and print the model syntax.
If \code{x} is a \verb{GenerateModel*()} result, it will format and print the model.}

\item{...}{Additional arguments (not used).}
}
\value{
Invisibly returns the formatted SEM model syntax.
}
\description{
Formats and prints the SEM model syntax generated by
\code{GenerateModelCN}, \code{GenerateModelCP}, \code{GenerateModelP}, and \code{GenerateModelPC}.
It organizes the equations into labeled sections for better readability.
}
\examples{
data(example_data)
head(example_data)
prepared_data <- PrepareData(
  data = example_data,
  M_C1 = c("A1", "B1"),
  M_C2 = c("A2", "B2"),
  Y_C1 = "C1",
  Y_C2 = "C2"
)
sem_model <- GenerateModelPC(prepared_data)
printGM(sem_model)
}
