% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_cases.r
\name{ws_tdiff_equal_params}
\alias{ws_tdiff_equal_params}
\title{Equal Parameters Special Case}
\usage{
ws_tdiff_equal_params(mu, sigma, nu)
}
\arguments{
\item{mu}{Common location parameter}

\item{sigma}{Common scale parameter (must be > 0)}

\item{nu}{Common degrees of freedom (must be > 4)}
}
\value{
An S3 object of class "ws_tdiff_univariate" with the simplified parameters
}
\description{
Computes the Welch-Satterthwaite approximation for the special case where
both distributions have identical parameters.
}
\details{
When X1 ~ t(mu, sigma^2, nu) and X2 ~ t(mu, sigma^2, nu) are independent,
the difference Z = X1 - X2 simplifies to:
\itemize{
  \item Location: mu_diff = 0
  \item Scale: sigma_star = sigma * sqrt(2*nu/(nu-2))
  \item Degrees of freedom: nu_star = 2*(nu - 4)
}

This special case provides validation for the general formulas and
computational efficiency when parameters are known to be equal.
}
\examples{
# Equal parameters case
result <- ws_tdiff_equal_params(mu = 0, sigma = 1, nu = 10)
print(result)
# nu_star should be 2*(10-4) = 12

# Verify against general formula
general <- ws_tdiff_univariate(0, 1, 10, 0, 1, 10)
all.equal(result$nu_star, general$nu_star)

}
