% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{batch_modwt_wvar_cpp}
\alias{batch_modwt_wvar_cpp}
\title{Computes the MO/DWT wavelet variance for multiple processes}
\usage{
batch_modwt_wvar_cpp(
  signal,
  nlevels,
  robust,
  eff,
  alpha,
  ci_type,
  strWavelet,
  decomp
)
}
\arguments{
\item{signal}{A \code{matrix} that contains the same number of observations per dataset}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}

\item{alpha}{A \code{double} that indicates the \eqn{\left(1-p\right)\times \alpha}{(1-p)*alpha} confidence level}

\item{ci_type}{A \code{string} indicating the confidence interval being calculated. Valid value: "eta3"}

\item{strWavelet}{A \code{string} indicating the type of wave filter to be applied. Must be "haar"}

\item{decomp}{A \code{string} indicating whether to use "modwt" or "dwt" decomp}
}
\value{
A \code{field<mat>} with the structure:
\item{variance}{Wavelet Variance.}
\item{low}{Lower Confidence Interval.}
\item{high}{Upper Confidence Interval.}
}
\description{
Calculates the MO/DWT wavelet variance
}
\details{
This function processes the decomposition of multiple signals quickly
}
\keyword{internal}
