% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerturbationImportance.R
\name{RFI}
\alias{RFI}
\title{Relative Feature Importance}
\description{
RFI generalizes CFI and PFI with arbitrary conditioning sets and samplers.
}
\examples{
\dontshow{if (requireNamespace("ranger", quietly = TRUE) && requireNamespace("mlr3learners", quietly = TRUE) && requireNamespace("arf", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(mlr3)
task = tgen("friedman1")$generate(n = 200)
rfi = RFI$new(
  task = task,
  learner = lrn("regr.ranger", num.trees = 50),
  measure = msr("regr.mse"),
  conditioning_set = c("important1")
)
rfi$compute()
rfi$importance()
\dontshow{\}) # examplesIf}
}
\references{
König G, Molnar C, Bischl B, Grosse-Wentrup M (2021).
\dQuote{Relative Feature Importance.}
In \emph{2020 25th International Conference on Pattern Recognition (ICPR)}, 9318--9325.
\doi{10.1109/ICPR48806.2021.9413090}.
}
\section{Super classes}{
\code{\link[xplainfi:FeatureImportanceMethod]{xplainfi::FeatureImportanceMethod}} -> \code{\link[xplainfi:PerturbationImportance]{xplainfi::PerturbationImportance}} -> \code{RFI}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RFI-new}{\code{RFI$new()}}
\item \href{#method-RFI-compute}{\code{RFI$compute()}}
\item \href{#method-RFI-clone}{\code{RFI$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="obs_loss"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-obs_loss'><code>xplainfi::FeatureImportanceMethod$obs_loss()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="print"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-print'><code>xplainfi::FeatureImportanceMethod$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="reset"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-reset'><code>xplainfi::FeatureImportanceMethod$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureImportanceMethod" data-id="scores"><a href='../../xplainfi/html/FeatureImportanceMethod.html#method-FeatureImportanceMethod-scores'><code>xplainfi::FeatureImportanceMethod$scores()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="PerturbationImportance" data-id="importance"><a href='../../xplainfi/html/PerturbationImportance.html#method-PerturbationImportance-importance'><code>xplainfi::PerturbationImportance$importance()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RFI-new"></a>}}
\if{latex}{\out{\hypertarget{method-RFI-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of the RFI class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFI$new(
  task,
  learner,
  measure = NULL,
  resampling = NULL,
  features = NULL,
  groups = NULL,
  conditioning_set = NULL,
  relation = "difference",
  n_repeats = 1L,
  batch_size = NULL,
  sampler = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task, learner, measure, resampling, features, groups, relation, n_repeats, batch_size}}{Passed to \link{PerturbationImportance}.}

\item{\code{conditioning_set}}{(\code{\link[=character]{character()}}) Set of features to condition on. Can be overridden in \verb{$compute()}.
Default (\code{character(0)}) is equivalent to \code{PFI}. In \code{CFI}, this would be set to all features except that of interest.}

\item{\code{sampler}}{(\link{ConditionalSampler}) Optional custom sampler. Defaults to \code{ConditionalARFSampler}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RFI-compute"></a>}}
\if{latex}{\out{\hypertarget{method-RFI-compute}{}}}
\subsection{Method \code{compute()}}{
Compute RFI scores
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFI$compute(
  conditioning_set = NULL,
  n_repeats = NULL,
  batch_size = NULL,
  store_models = TRUE,
  store_backends = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conditioning_set}}{(\code{character()}) Set of features to condition on. If \code{NULL}, uses the stored parameter value.}

\item{\code{n_repeats}}{(\code{integer(1)}) Number of permutation iterations. If \code{NULL}, uses stored value.}

\item{\code{batch_size}}{(\code{integer(1)} | \code{NULL}: \code{NULL}) Maximum number of rows to predict at once. If \code{NULL}, uses stored value.}

\item{\code{store_models, store_backends}}{(\code{logical(1)}: \code{TRUE}) Whether to store fitted models / data backends, passed to \link[mlr3:resample]{mlr3::resample} internally
for the initial fit of the learner.
This may be required for certain measures and is recommended to leave enabled unless really necessary.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RFI-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RFI-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RFI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
